/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.jbake.app.Oven;
import org.jbake.app.configuration.JBakeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFSChangeListener
implements FileListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFSChangeListener.class);
    private JBakeConfiguration config;

    public CustomFSChangeListener(JBakeConfiguration config) {
        this.config = config;
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        LOGGER.info("File created event detected: {}", (Object)event.getFile().getURL());
        this.exec(event.getFile());
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        LOGGER.info("File deleted event detected: {}", (Object)event.getFile().getURL());
        this.exec(event.getFile());
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        LOGGER.info("File changed event detected: {}", (Object)event.getFile().getURL());
        this.exec(event.getFile());
    }

    private void exec(FileObject file) {
        Oven oven = new Oven(this.config);
        oven.bake(new File(file.getName().getPath()));
    }
}

