/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.commons.configuration.ConfigurationException;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.launcher.BakeWatcher;
import org.jbake.launcher.Baker;
import org.jbake.launcher.Init;
import org.jbake.launcher.JettyServer;
import org.jbake.launcher.LaunchOptions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    private final String USAGE_PREFIX = "Usage: jbake";
    private final String ALT_USAGE_PREFIX = "   or  jbake";
    private Baker baker;
    private JettyServer jettyServer;
    private BakeWatcher watcher;
    private JBakeConfigurationFactory configurationFactory;

    public Main() {
        this(new Baker(), new JettyServer(), new BakeWatcher());
    }

    protected Main(Baker baker, JettyServer jetty, BakeWatcher watcher) {
        this.baker = baker;
        this.jettyServer = jetty;
        this.watcher = watcher;
        this.configurationFactory = new JBakeConfigurationFactory();
    }

    public static void main(String[] args) {
        try {
            new Main().run(args);
        }
        catch (JBakeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("An unexpected error occurred: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected void run(String[] args) {
        DefaultJBakeConfiguration config;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LaunchOptions res = this.parseArguments(args);
        try {
            config = res.isRunServer() ? this.getJBakeConfigurationFactory().createJettyJbakeConfiguration(res.getSource(), res.getDestination(), res.isClearCache()) : this.getJBakeConfigurationFactory().createDefaultJbakeConfiguration(res.getSource(), res.getDestination(), res.isClearCache());
        }
        catch (ConfigurationException e) {
            throw new JBakeException("Configuration error: " + e.getMessage(), e);
        }
        this.run(res, config);
    }

    protected void run(LaunchOptions res, JBakeConfiguration config) {
        System.out.println("JBake " + config.getVersion() + " (" + config.getBuildTimeStamp() + ") [http://jbake.org]");
        System.out.println();
        if (res.isHelpNeeded()) {
            this.printUsage(res);
            return;
        }
        if (res.isBake()) {
            this.baker.bake(config);
        }
        if (res.isInit()) {
            this.initStructure(res.getTemplate(), config);
        }
        if (res.isRunServer()) {
            this.watcher.start(config);
            if (res.isBake()) {
                if (res.getDestination() != null) {
                    this.runServer(res.getDestination(), config.getServerPort());
                } else if (!res.getSource().getPath().equals(".")) {
                    this.runServer(res.getSource(), config.getServerPort());
                } else {
                    this.runServer(config.getDestinationFolder(), config.getServerPort());
                }
            } else {
                this.runServer(config.getDestinationFolder(), config.getServerPort());
            }
        }
    }

    private LaunchOptions parseArguments(String[] args) {
        LaunchOptions res = new LaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)res);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.printUsage(res);
            throw new JBakeException("Invalid commandline arguments: " + e.getMessage(), e);
        }
        return res;
    }

    private void printUsage(Object options) {
        CmdLineParser parser = new CmdLineParser(options);
        StringWriter sw = new StringWriter();
        sw.append("Usage: jbake\n");
        sw.append("   or  jbake <source> <destination>\n");
        sw.append("   or  jbake [OPTION]... [<value>...]\n\n");
        sw.append("Options:");
        System.out.println(sw.toString());
        parser.getProperties().withUsageWidth(100);
        parser.printUsage((OutputStream)System.out);
    }

    private void runServer(File path, int port) {
        this.jettyServer.run(path.getPath(), String.valueOf(port));
    }

    private void initStructure(String type, JBakeConfiguration config) {
        Init init = new Init(config);
        try {
            File templateFolder = FileUtil.getRunningLocation();
            File outputFolder = config.getSourceFolder() != null ? config.getSourceFolder() : new File(".");
            init.run(outputFolder, templateFolder, type);
            System.out.println("Base folder structure successfully created.");
        }
        catch (Exception e) {
            String msg = "Failed to initialise structure: " + e.getMessage();
            throw new JBakeException(msg, e);
        }
    }

    public JBakeConfigurationFactory getJBakeConfigurationFactory() {
        return this.configurationFactory;
    }

    public void setJBakeConfigurationFactory(JBakeConfigurationFactory factory) {
        this.configurationFactory = factory;
    }
}

