/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import groovy.lang.GString;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;

public class GroovyMarkupTemplateEngine
extends AbstractTemplateEngine {
    private TemplateConfiguration templateConfiguration;
    private MarkupTemplateEngine templateEngine;

    @Deprecated
    public GroovyMarkupTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
        this.setupTemplateConfiguration();
        this.initializeTemplateEngine();
    }

    public GroovyMarkupTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.setupTemplateConfiguration();
        this.initializeTemplateEngine();
    }

    private void setupTemplateConfiguration() {
        this.templateConfiguration = new TemplateConfiguration();
        this.templateConfiguration.setUseDoubleQuotes(true);
        this.templateConfiguration.setAutoIndent(true);
        this.templateConfiguration.setAutoNewLine(true);
        this.templateConfiguration.setAutoEscape(true);
    }

    private void initializeTemplateEngine() {
        this.templateEngine = new MarkupTemplateEngine(MarkupTemplateEngine.class.getClassLoader(), this.config.getTemplateFolder(), this.templateConfiguration);
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.templateEngine.createTemplateByPath(templateName);
            Map<String, Object> wrappedModel = this.wrap(model);
            Writable writable = template.make(wrappedModel);
            writable.writeTo(writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }

    private Map<String, Object> wrap(final Map<String, Object> model) {
        return new HashMap<String, Object>(model){

            @Override
            public Object get(Object property) {
                if (property instanceof String || property instanceof GString) {
                    String key = property.toString();
                    try {
                        this.put(key, AbstractTemplateEngine.extractors.extractAndTransform(GroovyMarkupTemplateEngine.this.db, key, model, new TemplateEngineAdapter.NoopAdapter()));
                    }
                    catch (NoModelExtractorException noModelExtractorException) {
                        // empty catch block
                    }
                }
                return super.get(property);
            }
        };
    }
}

