/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.escaper.EscaperExtension;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;

public class PebbleTemplateEngine
extends AbstractTemplateEngine {
    private PebbleEngine engine;

    public PebbleTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.initializeTemplateEngine();
    }

    private void initializeTemplateEngine() {
        FileLoader loader = new FileLoader();
        loader.setPrefix(this.config.getTemplateFolder().getAbsolutePath());
        EscaperExtension escaper = new EscaperExtension();
        escaper.setAutoEscaping(false);
        this.engine = new PebbleEngine.Builder().loader((Loader)loader).extension(new Extension[]{escaper}).build();
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        try {
            PebbleTemplate template = this.engine.getTemplate(templateName);
            template.evaluate(writer, this.wrap(model));
        }
        catch (PebbleException e) {
            throw new RenderingException(e);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
    }

    private Map<String, Object> wrap(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model){
            private static final long serialVersionUID = -5489285491728950547L;

            @Override
            public Object get(Object property) {
                String key = property.toString();
                try {
                    return AbstractTemplateEngine.extractors.extractAndTransform(PebbleTemplateEngine.this.db, key, this, new TemplateEngineAdapter.NoopAdapter());
                }
                catch (NoModelExtractorException noModelExtractorException) {
                    return super.get(property);
                }
            }
        };
        return result;
    }
}

