/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEngines.class);
    private final Map<String, AbstractTemplateEngine> engines = new HashMap<String, AbstractTemplateEngine>();

    public Set<String> getRecognizedExtensions() {
        return Collections.unmodifiableSet(this.engines.keySet());
    }

    public TemplateEngines(JBakeConfiguration config, ContentStore db) {
        this.loadEngines(config, db);
    }

    private void registerEngine(String fileExtension, AbstractTemplateEngine templateEngine) {
        AbstractTemplateEngine old = this.engines.put(fileExtension, templateEngine);
        if (old != null) {
            LOGGER.warn("Registered a template engine for extension [.{}] but another one was already defined: {}", (Object)fileExtension, (Object)old);
        }
    }

    public AbstractTemplateEngine getEngine(String fileExtension) {
        return this.engines.get(fileExtension);
    }

    private static AbstractTemplateEngine tryLoadEngine(JBakeConfiguration config, ContentStore db, String engineClassName) {
        try {
            Class<?> engineClass = Class.forName(engineClassName, false, TemplateEngines.class.getClassLoader());
            Constructor<?> ctor = engineClass.getConstructor(JBakeConfiguration.class, ContentStore.class);
            return (AbstractTemplateEngine)ctor.newInstance(config, db);
        }
        catch (Throwable e) {
            LOGGER.warn("Template engine not available: {}", (Object)engineClassName);
            return null;
        }
    }

    private void loadEngines(JBakeConfiguration config, ContentStore db) {
        try {
            ClassLoader cl = TemplateEngines.class.getClassLoader();
            Enumeration<URL> resources = cl.getResources("META-INF/org.jbake.parser.TemplateEngines.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String className = (String)entry.getKey();
                    String[] extensions = ((String)entry.getValue()).split(",");
                    this.registerEngine(config, db, className, extensions);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading engines", (Throwable)e);
        }
    }

    private void registerEngine(JBakeConfiguration config, ContentStore db, String className, String ... extensions) {
        AbstractTemplateEngine engine = TemplateEngines.tryLoadEngine(config, db, className);
        if (engine != null) {
            for (String extension : extensions) {
                this.registerEngine(extension, engine);
            }
        }
    }
}

