/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.FileUtil;
import org.jbake.app.Parser;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.model.DocumentModel;
import org.jbake.model.DocumentStatus;
import org.jbake.model.DocumentTypes;
import org.jbake.util.HtmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    private static final Logger logger = LoggerFactory.getLogger(Crawler.class);
    private final ContentStore db;
    private final JBakeConfiguration config;
    private final Parser parser;

    @Deprecated
    public Crawler(ContentStore db, File source, CompositeConfiguration config) {
        this.db = db;
        this.config = new JBakeConfigurationFactory().createDefaultJbakeConfiguration(source, config);
        this.parser = new Parser(this.config);
    }

    public Crawler(ContentStore db, JBakeConfiguration config) {
        this.db = db;
        this.config = config;
        this.parser = new Parser(config);
    }

    public void crawl() {
        this.crawl(this.config.getContentFolder());
        logger.info("Content detected:");
        for (String docType : DocumentTypes.getDocumentTypes()) {
            long count = this.db.getDocumentCount(docType);
            if (count <= 0L) continue;
            logger.info("Parsed {} files of type: {}", (Object)count, (Object)docType);
        }
    }

    public void crawlDataFiles() {
        this.crawlDataFiles(this.config.getDataFolder());
        logger.info("Data files detected:");
        String docType = this.config.getDataFileDocType();
        long count = this.db.getDocumentCount(docType);
        if (count > 0L) {
            logger.info("Parsed {} files", (Object)count);
        }
    }

    private void crawl(File path) {
        Object[] contents = path.listFiles(FileUtil.getFileFilter(this.config));
        if (contents != null) {
            Arrays.sort(contents);
            for (Object sourceFile : contents) {
                if (((File)sourceFile).isFile()) {
                    this.crawlFile((File)sourceFile);
                    continue;
                }
                if (!((File)sourceFile).isDirectory()) continue;
                this.crawl((File)sourceFile);
            }
        }
    }

    private void crawlFile(File sourceFile) {
        StringBuilder sb = new StringBuilder();
        sb.append("Processing [").append(sourceFile.getPath()).append("]... ");
        String sha1 = this.buildHash(sourceFile);
        String uri = this.buildURI(sourceFile);
        DocumentStatus status = this.findDocumentStatus(uri, sha1);
        if (status == DocumentStatus.UPDATED) {
            sb.append(" : modified ");
            this.db.deleteContent(uri);
        } else if (status == DocumentStatus.IDENTICAL) {
            sb.append(" : same ");
        } else if (DocumentStatus.NEW == status) {
            sb.append(" : new ");
        }
        logger.info("{}", (Object)sb);
        if (status != DocumentStatus.IDENTICAL) {
            this.processSourceFile(sourceFile, sha1, uri);
        }
    }

    private void crawlDataFiles(File path) {
        Object[] contents = path.listFiles(FileUtil.getDataFileFilter());
        if (contents != null) {
            Arrays.sort(contents);
            for (Object sourceFile : contents) {
                if (((File)sourceFile).isFile()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Processing [").append(((File)sourceFile).getPath()).append("]... ");
                    String sha1 = this.buildHash((File)sourceFile);
                    String uri = this.buildDataFileURI((File)sourceFile);
                    boolean process = true;
                    DocumentStatus status = DocumentStatus.NEW;
                    String docType = this.config.getDataFileDocType();
                    status = this.findDocumentStatus(uri, sha1);
                    if (status == DocumentStatus.UPDATED) {
                        sb.append(" : modified ");
                        this.db.deleteContent(uri);
                    } else if (status == DocumentStatus.IDENTICAL) {
                        sb.append(" : same ");
                        process = false;
                    }
                    if (!process) break;
                    if (DocumentStatus.NEW == status) {
                        sb.append(" : new ");
                    }
                    if (process) {
                        this.crawlDataFile((File)sourceFile, sha1, uri, docType);
                    }
                    logger.info("{}", (Object)sb);
                }
                if (!((File)sourceFile).isDirectory()) continue;
                this.crawlDataFiles((File)sourceFile);
            }
        }
    }

    private String buildHash(File sourceFile) {
        String sha1;
        try {
            sha1 = FileUtil.sha1(sourceFile);
        }
        catch (Exception e) {
            logger.error("unable to build sha1 hash for source file '{}'", (Object)sourceFile);
            sha1 = "";
        }
        return sha1;
    }

    private String buildURI(File sourceFile) {
        String uri = FileUtil.asPath(sourceFile).replace(FileUtil.asPath(this.config.getContentFolder()), "");
        uri = this.useNoExtensionUri(uri) ? this.createNoExtensionUri(uri) : this.createUri(uri);
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    private String buildDataFileURI(File sourceFile) {
        String uri = FileUtil.asPath(sourceFile).replace(FileUtil.asPath(this.config.getDataFolder()), "");
        if (uri.startsWith("/")) {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    private String createUri(String uri) {
        try {
            return "/" + FilenameUtils.getPath((String)uri) + URLEncoder.encode(FilenameUtils.getBaseName((String)uri), StandardCharsets.UTF_8.name()) + this.config.getOutputExtension();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding??", e);
        }
    }

    private String createNoExtensionUri(String uri) {
        try {
            return "/" + FilenameUtils.getPath((String)uri) + URLEncoder.encode(FilenameUtils.getBaseName((String)uri), StandardCharsets.UTF_8.name()) + "/" + "index" + this.config.getOutputExtension();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding??", e);
        }
    }

    private boolean useNoExtensionUri(String uri) {
        boolean noExtensionUri = this.config.getUriWithoutExtension();
        String noExtensionUriPrefix = this.config.getPrefixForUriWithoutExtension();
        return noExtensionUri && noExtensionUriPrefix != null && noExtensionUriPrefix.length() > 0 && uri.startsWith(noExtensionUriPrefix);
    }

    private void crawlDataFile(File sourceFile, String sha1, String uri, String documentType) {
        try {
            DocumentModel document = this.parser.processFile(sourceFile);
            if (document != null) {
                document.setSha1(sha1);
                document.setRendered(true);
                document.setFile(sourceFile.getPath());
                document.setSourceUri(uri);
                document.setType(documentType);
                this.db.addDocument(document);
            } else {
                logger.warn("{} couldn't be parsed so it has been ignored!", (Object)sourceFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed crawling file: " + sourceFile.getPath() + " " + ex.getMessage(), ex);
        }
    }

    private void processSourceFile(File sourceFile, String sha1, String uri) {
        DocumentModel document = this.parser.processFile(sourceFile);
        if (document != null) {
            if (DocumentTypes.contains(document.getType())) {
                this.addAdditionalDocumentAttributes(document, sourceFile, sha1, uri);
                if (this.config.getImgPathUpdate()) {
                    HtmlUtil.fixImageSourceUrls(document, this.config);
                }
                this.db.addDocument(document);
            } else {
                logger.warn("{} has an unknown document type '{}' and has been ignored!", (Object)sourceFile, (Object)document.getType());
            }
        } else {
            logger.warn("{} has an invalid header, it has been ignored!", (Object)sourceFile);
        }
    }

    private void addAdditionalDocumentAttributes(DocumentModel document, File sourceFile, String sha1, String uri) {
        document.setRootPath(this.getPathToRoot(sourceFile));
        document.setSha1(sha1);
        document.setRendered(false);
        document.setFile(sourceFile.getPath());
        document.setSourceUri(uri);
        document.setUri(uri);
        document.setCached(true);
        if (document.getStatus().equals("published-date") && document.getDate() != null && new Date().after(document.getDate())) {
            document.setStatus("published");
        }
        if (this.config.getUriWithoutExtension()) {
            document.setNoExtensionUri(uri.replace("/index.html", "/"));
        }
    }

    private String getPathToRoot(File sourceFile) {
        return FileUtil.getUriPathToContentRoot(this.config, sourceFile);
    }

    private DocumentStatus findDocumentStatus(String uri, String sha1) {
        DocumentList<DocumentModel> match = this.db.getDocumentStatus(uri);
        if (!match.isEmpty()) {
            DocumentModel document = (DocumentModel)match.get(0);
            String oldHash = document.getSha1();
            if (!oldHash.equals(sha1) || !document.getRendered().booleanValue()) {
                return DocumentStatus.UPDATED;
            }
            return DocumentStatus.IDENTICAL;
        }
        return DocumentStatus.NEW;
    }
}

