/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import org.jbake.app.FileUtil;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.parser.Engines;
import org.jbake.parser.ParserEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);
    private JBakeConfiguration config;

    public Parser(JBakeConfiguration config) {
        this.config = config;
    }

    public DocumentModel processFile(File file) {
        ParserEngine engine = Engines.get(FileUtil.fileExt(file));
        if (engine == null) {
            LOGGER.error("Unable to find suitable markup engine for {}", (Object)file);
            return null;
        }
        return engine.parse(this.config, file);
    }
}

