/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.LinkedList;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.model.DocumentModel;
import org.jbake.template.DelegatingTemplateEngine;
import org.jbake.template.model.TemplateModel;
import org.jbake.util.PagingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final String MASTERINDEX_TEMPLATE_NAME = "masterindex";
    private static final String SITEMAP_TEMPLATE_NAME = "sitemap";
    private static final String FEED_TEMPLATE_NAME = "feed";
    private static final String ARCHIVE_TEMPLATE_NAME = "archive";
    private static final String ERROR404_TEMPLATE_NAME = "error404";
    private final Logger logger = LoggerFactory.getLogger(Renderer.class);
    private final JBakeConfiguration config;
    private final DelegatingTemplateEngine renderingEngine;
    private final ContentStore db;

    @Deprecated
    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config) {
        this(db, new JBakeConfigurationFactory().createDefaultJbakeConfiguration(templatesPath.getParentFile(), config));
        DefaultJBakeConfiguration configuration = (DefaultJBakeConfiguration)this.config;
        configuration.setDestinationFolder(destination);
        configuration.setTemplateFolder(templatesPath);
    }

    @Deprecated
    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config, DelegatingTemplateEngine renderingEngine) {
        this(db, new JBakeConfigurationFactory().createDefaultJbakeConfiguration(templatesPath.getParentFile(), config), renderingEngine);
        DefaultJBakeConfiguration configuration = (DefaultJBakeConfiguration)this.config;
        configuration.setDestinationFolder(destination);
        configuration.setTemplateFolder(templatesPath);
    }

    public Renderer(ContentStore db, JBakeConfiguration config) {
        this.config = config;
        this.renderingEngine = new DelegatingTemplateEngine(db, config);
        this.db = db;
    }

    public Renderer(ContentStore db, JBakeConfiguration config, DelegatingTemplateEngine renderingEngine) {
        this.config = config;
        this.renderingEngine = renderingEngine;
        this.db = db;
    }

    private String findTemplateName(String docType) {
        return this.config.getTemplateFileByDocType(docType).getName();
    }

    public void render(DocumentModel content) throws Exception {
        File publishedFile;
        String docType = content.getType();
        String outputFilename = this.config.getDestinationFolder().getPath() + File.separatorChar + content.getUri();
        if (outputFilename.lastIndexOf(46) > outputFilename.lastIndexOf(File.separatorChar)) {
            outputFilename = outputFilename.substring(0, outputFilename.lastIndexOf(46));
        }
        String outputExtension = this.config.getOutputExtensionByDocType(docType);
        File draftFile = new File(outputFilename, this.config.getDraftSuffix() + outputExtension);
        if (draftFile.exists()) {
            Files.delete(draftFile.toPath());
        }
        if ((publishedFile = new File(outputFilename + outputExtension)).exists()) {
            Files.delete(publishedFile.toPath());
        }
        if (content.getStatus().equals("draft")) {
            outputFilename = outputFilename + this.config.getDraftSuffix();
        }
        File outputFile = new File(outputFilename + outputExtension);
        TemplateModel model = new TemplateModel();
        model.setContent(content);
        model.setRenderer(this.renderingEngine);
        try {
            try (Writer out = this.createWriter(outputFile);){
                this.renderingEngine.renderDocument(model, this.findTemplateName(docType), out);
            }
            this.logger.info("Rendering [{}]... done!", (Object)outputFile);
        }
        catch (Exception e) {
            this.logger.error("Rendering [{}]... failed!", (Object)outputFile, (Object)e);
            throw new Exception("Failed to render file " + outputFile.getAbsolutePath() + ". Cause: " + e.getMessage(), e);
        }
    }

    private Writer createWriter(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.config.getRenderEncoding());
    }

    private void render(RenderingConfig renderConfig) throws Exception {
        File outputFile = renderConfig.getPath();
        try {
            try (Writer out = this.createWriter(outputFile);){
                this.renderingEngine.renderDocument(renderConfig.getModel(), renderConfig.getTemplate(), out);
            }
            this.logger.info("Rendering {} [{}]... done!", (Object)renderConfig.getName(), (Object)outputFile);
        }
        catch (Exception e) {
            this.logger.error("Rendering {} [{}]... failed!", new Object[]{renderConfig.getName(), outputFile, e});
            throw new Exception("Failed to render " + renderConfig.getName(), e);
        }
    }

    public void renderIndex(String indexFile) throws Exception {
        this.render(new DefaultRenderingConfig(indexFile, MASTERINDEX_TEMPLATE_NAME));
    }

    public void renderIndexPaging(String indexFile) throws Exception {
        long totalPosts = this.db.getPublishedCount("post");
        int postsPerPage = this.config.getPostsPerPage();
        if (totalPosts == 0L) {
            this.renderIndex(indexFile);
        } else {
            PagingHelper pagingHelper = new PagingHelper(totalPosts, postsPerPage);
            TemplateModel model = new TemplateModel();
            model.setRenderer(this.renderingEngine);
            model.setNumberOfPages(pagingHelper.getNumberOfPages());
            try {
                this.db.setLimit(postsPerPage);
                int pageStart = 0;
                int page = 1;
                while ((long)pageStart < totalPosts) {
                    String fileName = indexFile;
                    this.db.setStart(pageStart);
                    model.setCurrentPageNuber(page);
                    String previous = pagingHelper.getPreviousFileName(page);
                    model.setPreviousFilename(previous);
                    String nextFileName = pagingHelper.getNextFileName(page);
                    model.setNextFileName(nextFileName);
                    DocumentModel contentModel = this.buildSimpleModel(MASTERINDEX_TEMPLATE_NAME);
                    if (page > 1) {
                        contentModel.setRootPath("../");
                    }
                    model.setContent(contentModel);
                    fileName = pagingHelper.getCurrentFileName(page, fileName);
                    ModelRenderingConfig renderConfig = new ModelRenderingConfig(fileName, model, MASTERINDEX_TEMPLATE_NAME);
                    this.render(renderConfig);
                    pageStart += postsPerPage;
                    ++page;
                }
                this.db.resetPagination();
            }
            catch (Exception e) {
                throw new Exception("Failed to render index. Cause: " + e.getMessage(), e);
            }
        }
    }

    public void renderSitemap(String sitemapFile) throws Exception {
        this.render(new DefaultRenderingConfig(sitemapFile, SITEMAP_TEMPLATE_NAME));
    }

    public void renderFeed(String feedFile) throws Exception {
        this.render(new DefaultRenderingConfig(feedFile, FEED_TEMPLATE_NAME));
    }

    public void renderArchive(String archiveFile) throws Exception {
        this.render(new DefaultRenderingConfig(archiveFile, ARCHIVE_TEMPLATE_NAME));
    }

    public void renderError404(String errorFile) throws Exception {
        this.render(new DefaultRenderingConfig(errorFile, ERROR404_TEMPLATE_NAME));
    }

    public int renderTags(String tagPath) throws Exception {
        int renderedCount = 0;
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (String tag : this.db.getAllTags()) {
            try {
                TemplateModel templateModel = new TemplateModel();
                templateModel.setRenderer(this.renderingEngine);
                templateModel.setTag(tag);
                DocumentModel map = this.buildSimpleModel("tag".toString());
                File path = new File(this.config.getDestinationFolder() + File.separator + tagPath + File.separator + tag + this.config.getOutputExtension());
                map.setRootPath(FileUtil.getUriPathToDestinationRoot(this.config, path));
                templateModel.setContent(map);
                this.render(new ModelRenderingConfig(path, "tag".toString(), templateModel, this.findTemplateName("tag".toString())));
                ++renderedCount;
            }
            catch (Exception exception) {
                errors.add(exception);
            }
        }
        if (this.config.getRenderTagsIndex()) {
            try {
                TemplateModel model = new TemplateModel();
                model.setRenderer(this.renderingEngine);
                DocumentModel map = this.buildSimpleModel("tags".toString());
                File file = new File(this.config.getDestinationFolder() + File.separator + tagPath + File.separator + "index" + this.config.getOutputExtension());
                map.setRootPath(FileUtil.getUriPathToDestinationRoot(this.config, file));
                model.setContent(map);
                this.render(new ModelRenderingConfig(file, "tagindex", model, this.findTemplateName("tagsindex")));
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render tags. Cause(s):");
            for (Throwable throwable : errors) {
                sb.append("\n").append(throwable.getMessage());
            }
            throw new Exception(sb.toString(), (Throwable)errors.get(0));
        }
        return renderedCount;
    }

    private DocumentModel buildSimpleModel(String type) {
        DocumentModel content = new DocumentModel();
        content.setType(type);
        content.setRootPath("");
        return content;
    }

    class DefaultRenderingConfig
    extends AbstractRenderingConfig {
        private final DocumentModel content;

        private DefaultRenderingConfig(File path, String allInOneName) {
            super(path, allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String filename, String allInOneName) {
            super(new File(Renderer.this.config.getDestinationFolder(), File.separator + filename), allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String allInOneName) {
            this(new File(this$0.config.getDestinationFolder().getPath() + File.separator + allInOneName + this$0.config.getOutputExtension()), allInOneName);
        }

        @Override
        public TemplateModel getModel() {
            TemplateModel model = new TemplateModel();
            model.setRenderer(Renderer.this.renderingEngine);
            model.setContent(this.content);
            if (Renderer.this.config.getPaginateIndex()) {
                model.setNumberOfPages(0);
                model.setCurrentPageNuber(0);
                model.setPreviousFilename("");
                model.setNextFileName("");
            }
            return model;
        }
    }

    public class ModelRenderingConfig
    extends AbstractRenderingConfig {
        private final TemplateModel model;

        public ModelRenderingConfig(String fileName, TemplateModel model, String templateType) {
            super(new File(Renderer.this.config.getDestinationFolder(), fileName), fileName, Renderer.this.findTemplateName(templateType));
            this.model = model;
        }

        public ModelRenderingConfig(File path, String name, TemplateModel model, String template) {
            super(path, name, template);
            this.model = model;
        }

        @Override
        public TemplateModel getModel() {
            return this.model;
        }
    }

    private static abstract class AbstractRenderingConfig
    implements RenderingConfig {
        protected final File path;
        protected final String name;
        protected final String template;

        public AbstractRenderingConfig(File path, String name, String template) {
            this.path = path;
            this.name = name;
            this.template = template;
        }

        @Override
        public File getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }
    }

    private static interface RenderingConfig {
        public File getPath();

        public String getName();

        public String getTemplate();

        public TemplateModel getModel();
    }
}

