/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.launcher.SystemExit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    public static final char LIST_DELIMITER = ',';
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    public static final String LEGACY_CONFIG_FILE = "custom.properties";
    public static final String CONFIG_FILE = "jbake.properties";
    public static final String DEFAULT_CONFIG_FILE = "default.properties";
    private String encoding = "UTF-8";

    private CompositeConfiguration load(File source, File propertiesFile) throws ConfigurationException {
        URL defaultPropertiesLocation;
        if (!source.exists()) {
            throw new JBakeException(SystemExit.CONFIGURATION_ERROR, "The given source folder '" + source.getAbsolutePath() + "' does not exist.");
        }
        if (!source.isDirectory()) {
            throw new JBakeException(SystemExit.CONFIGURATION_ERROR, "The given source folder is not a directory.");
        }
        File legacyConfigFile = new File(source, LEGACY_CONFIG_FILE);
        File customConfigFile = propertiesFile != null ? propertiesFile : new File(source, CONFIG_FILE);
        CompositeConfiguration config = new CompositeConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        if (legacyConfigFile.exists()) {
            this.displayLegacyConfigFileWarningIfRequired();
            config.addConfiguration((Configuration)this.getFileBasedPropertiesConfiguration(legacyConfigFile));
        }
        if (customConfigFile.exists()) {
            config.addConfiguration((Configuration)this.getFileBasedPropertiesConfiguration(customConfigFile));
        }
        if ((defaultPropertiesLocation = this.getClass().getClassLoader().getResource(DEFAULT_CONFIG_FILE)) != null) {
            config.addConfiguration((Configuration)this.getFileBasedPropertiesConfiguration(defaultPropertiesLocation));
        }
        config.addConfiguration((Configuration)new SystemConfiguration());
        return config;
    }

    private PropertiesConfiguration getFileBasedPropertiesConfiguration(File propertiesFile) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(propertiesFile)).setEncoding(this.encoding)).setThrowExceptionOnMissing(true)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setIncludesAllowed(false)});
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    private PropertiesConfiguration getFileBasedPropertiesConfiguration(URL propertiesFile) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setURL(propertiesFile)).setEncoding(this.encoding)).setThrowExceptionOnMissing(true)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setIncludesAllowed(false)});
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    private void displayLegacyConfigFileWarningIfRequired() {
        LOGGER.warn("You have defined a part of your JBake configuration in {}", (Object)LEGACY_CONFIG_FILE);
        LOGGER.warn("Usage of this file is being deprecated, please rename this file to: {} to remove this warning", (Object)CONFIG_FILE);
    }

    public JBakeConfiguration loadConfig(File source, File propertiesFile) throws JBakeException {
        try {
            CompositeConfiguration configuration = this.load(source, propertiesFile);
            return new DefaultJBakeConfiguration(source, configuration);
        }
        catch (ConfigurationException e) {
            throw new JBakeException(SystemExit.CONFIGURATION_ERROR, e.getMessage(), e);
        }
    }

    @Deprecated
    public JBakeConfiguration loadConfig(File source) throws ConfigurationException {
        return this.loadConfig(source, null);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ConfigUtil setEncoding(String encoding) {
        if (Charset.isSupported(encoding)) {
            this.encoding = encoding;
        } else {
            this.encoding = DEFAULT_ENCODING;
            LOGGER.warn("Unsupported encoding '{}'. Using default encoding '{}'", (Object)encoding, (Object)this.encoding);
        }
        return this;
    }
}

