/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.Property;
import org.jbake.app.configuration.PropertyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJBakeConfiguration
implements JBakeConfiguration {
    public static final String DEFAULT_TYHMELEAF_TEMPLATE_MODE = "HTML";
    private static final String SOURCE_FOLDER_KEY = "sourceFolder";
    private static final String DESTINATION_FOLDER_KEY = "destinationFolder";
    private static final String ASSET_FOLDER_KEY = "assetFolder";
    private static final String TEMPLATE_FOLDER_KEY = "templateFolder";
    private static final String CONTENT_FOLDER_KEY = "contentFolder";
    private static final String DATA_FOLDER_KEY = "dataFolder";
    private static final Pattern TEMPLATE_DOC_PATTERN = Pattern.compile("(?:template\\.)([a-zA-Z0-9-_]+)(?:\\.file)");
    private static final String DOCTYPE_FILE_POSTFIX = ".file";
    private static final String DOCTYPE_EXTENSION_POSTFIX = ".extension";
    private static final String DOCTYPE_TEMPLATE_PREFIX = "template.";
    private final Logger logger = LoggerFactory.getLogger(DefaultJBakeConfiguration.class);
    private CompositeConfiguration compositeConfiguration;

    @Deprecated
    public DefaultJBakeConfiguration(CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
    }

    public DefaultJBakeConfiguration(File sourceFolder, CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
        this.setSourceFolder(sourceFolder);
        this.setupPaths();
    }

    @Override
    public Object get(String key) {
        return this.compositeConfiguration.getProperty(key);
    }

    @Override
    public String getArchiveFileName() {
        return this.getAsString(PropertyList.ARCHIVE_FILE.getKey());
    }

    private boolean getAsBoolean(String key) {
        return this.compositeConfiguration.getBoolean(key, false);
    }

    private File getAsFolder(String key) {
        return (File)this.get(key);
    }

    private int getAsInt(String key, int defaultValue) {
        return this.compositeConfiguration.getInt(key, defaultValue);
    }

    private List<String> getAsList(String key) {
        return this.compositeConfiguration.getList(String.class, key);
    }

    private String getAsString(String key) {
        return this.compositeConfiguration.getString(key);
    }

    private String getAsString(String key, String defaultValue) {
        return this.compositeConfiguration.getString(key, defaultValue);
    }

    @Override
    public List<String> getAsciidoctorAttributes() {
        return this.getAsList(PropertyList.ASCIIDOCTOR_ATTRIBUTES.getKey());
    }

    @Override
    public List<String> getAsciidoctorOption(String optionKey) {
        Configuration subConfig = this.compositeConfiguration.subset(PropertyList.ASCIIDOCTOR_OPTION.getKey());
        if (subConfig.containsKey(optionKey)) {
            return subConfig.getList(String.class, optionKey);
        }
        this.logger.warn("Cannot find asciidoctor option '{}.{}'", (Object)PropertyList.ASCIIDOCTOR_OPTION.getKey(), (Object)optionKey);
        return Collections.emptyList();
    }

    @Override
    public List<String> getAsciidoctorOptionKeys() {
        ArrayList<String> options = new ArrayList<String>();
        Configuration subConfig = this.compositeConfiguration.subset(PropertyList.ASCIIDOCTOR_OPTION.getKey());
        Iterator iterator = subConfig.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            options.add(key);
        }
        return options;
    }

    @Override
    public File getAssetFolder() {
        return this.getAsFolder(ASSET_FOLDER_KEY);
    }

    public void setAssetFolder(File assetFolder) {
        if (assetFolder != null) {
            this.setProperty(ASSET_FOLDER_KEY, assetFolder);
        }
    }

    @Override
    public String getAssetFolderName() {
        return this.getAsString(PropertyList.ASSET_FOLDER.getKey());
    }

    @Override
    public boolean getAssetIgnoreHidden() {
        return this.getAsBoolean(PropertyList.ASSET_IGNORE_HIDDEN.getKey());
    }

    public void setAssetIgnoreHidden(boolean assetIgnoreHidden) {
        this.setProperty(PropertyList.ASSET_IGNORE_HIDDEN.getKey(), assetIgnoreHidden);
    }

    @Override
    public String getAttributesExportPrefixForAsciidoctor() {
        return this.getAsString(PropertyList.ASCIIDOCTOR_ATTRIBUTES_EXPORT_PREFIX.getKey(), "");
    }

    @Override
    public String getBuildTimeStamp() {
        return this.getAsString(PropertyList.BUILD_TIMESTAMP.getKey());
    }

    @Override
    public boolean getClearCache() {
        return this.getAsBoolean(PropertyList.CLEAR_CACHE.getKey());
    }

    public void setClearCache(boolean clearCache) {
        this.setProperty(PropertyList.CLEAR_CACHE.getKey(), clearCache);
    }

    public CompositeConfiguration getCompositeConfiguration() {
        return this.compositeConfiguration;
    }

    public void setCompositeConfiguration(CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
    }

    @Override
    public File getContentFolder() {
        return this.getAsFolder(CONTENT_FOLDER_KEY);
    }

    public void setContentFolder(File contentFolder) {
        if (contentFolder != null) {
            this.setProperty(CONTENT_FOLDER_KEY, contentFolder);
        }
    }

    @Override
    public String getContentFolderName() {
        return this.getAsString(PropertyList.CONTENT_FOLDER.getKey());
    }

    @Override
    public File getDataFolder() {
        return this.getAsFolder(DATA_FOLDER_KEY);
    }

    public void setDataFolder(File dataFolder) {
        if (dataFolder != null) {
            this.setProperty(DATA_FOLDER_KEY, dataFolder);
        }
    }

    @Override
    public String getDataFolderName() {
        return this.getAsString(PropertyList.DATA_FOLDER.getKey());
    }

    @Override
    public String getDataFileDocType() {
        return this.getAsString(PropertyList.DATA_FILE_DOCTYPE.getKey());
    }

    public void setDataFileDocType(String dataFileDocType) {
        this.setProperty(PropertyList.DATA_FILE_DOCTYPE.getKey(), dataFileDocType);
    }

    @Override
    public String getDatabasePath() {
        return this.getAsString(PropertyList.DB_PATH.getKey());
    }

    public void setDatabasePath(String path) {
        this.setProperty(PropertyList.DB_PATH.getKey(), path);
    }

    @Override
    public String getDatabaseStore() {
        return this.getAsString(PropertyList.DB_STORE.getKey());
    }

    public void setDatabaseStore(String storeType) {
        this.setProperty(PropertyList.DB_STORE.getKey(), storeType);
    }

    @Override
    public String getDateFormat() {
        return this.getAsString(PropertyList.DATE_FORMAT.getKey());
    }

    @Override
    public String getDefaultStatus() {
        return this.getAsString(PropertyList.DEFAULT_STATUS.getKey(), "");
    }

    public void setDefaultStatus(String status) {
        this.setProperty(PropertyList.DEFAULT_STATUS.getKey(), status);
    }

    @Override
    public String getDefaultType() {
        return this.getAsString(PropertyList.DEFAULT_TYPE.getKey(), "");
    }

    public void setDefaultType(String type) {
        this.setProperty(PropertyList.DEFAULT_TYPE.getKey(), type);
    }

    @Override
    public File getDestinationFolder() {
        return this.getAsFolder(DESTINATION_FOLDER_KEY);
    }

    @Override
    public void setDestinationFolder(File destinationFolder) {
        if (destinationFolder != null) {
            this.setProperty(DESTINATION_FOLDER_KEY, destinationFolder);
        }
    }

    @Override
    public List<String> getDocumentTypes() {
        ArrayList<String> docTypes = new ArrayList<String>();
        Iterator keyIterator = this.compositeConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Matcher matcher = TEMPLATE_DOC_PATTERN.matcher(key);
            if (!matcher.find()) continue;
            docTypes.add(matcher.group(1));
        }
        return docTypes;
    }

    @Override
    public String getDraftSuffix() {
        return this.getAsString(PropertyList.DRAFT_SUFFIX.getKey(), "");
    }

    @Override
    public String getError404FileName() {
        return this.getAsString(PropertyList.ERROR404_FILE.getKey());
    }

    @Override
    public String getExampleProjectByType(String templateType) {
        return this.getAsString("example.project." + templateType);
    }

    @Override
    public boolean getExportAsciidoctorAttributes() {
        return this.getAsBoolean(PropertyList.ASCIIDOCTOR_ATTRIBUTES_EXPORT.getKey());
    }

    @Override
    public String getFeedFileName() {
        return this.getAsString(PropertyList.FEED_FILE.getKey());
    }

    @Override
    public String getIgnoreFileName() {
        return this.getAsString(PropertyList.IGNORE_FILE.getKey());
    }

    @Override
    public String getIndexFileName() {
        return this.getAsString(PropertyList.INDEX_FILE.getKey());
    }

    @Override
    public Iterator<String> getKeys() {
        return this.compositeConfiguration.getKeys();
    }

    @Override
    public List<String> getMarkdownExtensions() {
        return this.getAsList(PropertyList.MARKDOWN_EXTENSIONS.getKey());
    }

    public void setMarkdownExtensions(String ... extensions) {
        this.setProperty(PropertyList.MARKDOWN_EXTENSIONS.getKey(), StringUtils.join((Object[])extensions, (String)","));
    }

    @Override
    public String getOutputExtension() {
        return this.getAsString(PropertyList.OUTPUT_EXTENSION.getKey());
    }

    public void setOutputExtension(String outputExtension) {
        this.setProperty(PropertyList.OUTPUT_EXTENSION.getKey(), outputExtension);
    }

    @Override
    public String getOutputExtensionByDocType(String docType) {
        String templateExtensionKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_EXTENSION_POSTFIX;
        String defaultOutputExtension = this.getOutputExtension();
        return this.getAsString(templateExtensionKey, defaultOutputExtension);
    }

    @Override
    public boolean getPaginateIndex() {
        return this.getAsBoolean(PropertyList.PAGINATE_INDEX.getKey());
    }

    public void setPaginateIndex(boolean paginateIndex) {
        this.setProperty(PropertyList.PAGINATE_INDEX.getKey(), paginateIndex);
    }

    @Override
    public int getPostsPerPage() {
        return this.getAsInt(PropertyList.POSTS_PER_PAGE.getKey(), 5);
    }

    public void setPostsPerPage(int postsPerPage) {
        this.setProperty(PropertyList.POSTS_PER_PAGE.getKey(), postsPerPage);
    }

    @Override
    public String getPrefixForUriWithoutExtension() {
        return this.getAsString(PropertyList.URI_NO_EXTENSION_PREFIX.getKey());
    }

    public void setPrefixForUriWithoutExtension(String prefix) {
        this.setProperty(PropertyList.URI_NO_EXTENSION_PREFIX.getKey(), prefix);
    }

    @Override
    public boolean getRenderArchive() {
        return this.getAsBoolean(PropertyList.RENDER_ARCHIVE.getKey());
    }

    @Override
    public String getRenderEncoding() {
        return this.getAsString(PropertyList.RENDER_ENCODING.getKey());
    }

    @Override
    public String getOutputEncoding() {
        return this.getAsString(PropertyList.OUTPUT_ENCODING.getKey());
    }

    @Override
    public boolean getRenderError404() {
        return this.getAsBoolean(PropertyList.RENDER_ERROR404.getKey());
    }

    @Override
    public boolean getRenderFeed() {
        return this.getAsBoolean(PropertyList.RENDER_FEED.getKey());
    }

    @Override
    public boolean getRenderIndex() {
        return this.getAsBoolean(PropertyList.RENDER_INDEX.getKey());
    }

    @Override
    public boolean getRenderSiteMap() {
        return this.getAsBoolean(PropertyList.RENDER_SITEMAP.getKey());
    }

    @Override
    public boolean getRenderTags() {
        return this.getAsBoolean(PropertyList.RENDER_TAGS.getKey());
    }

    @Override
    public boolean getRenderTagsIndex() {
        return this.compositeConfiguration.getBoolean(PropertyList.RENDER_TAGS_INDEX.getKey(), false);
    }

    public void setRenderTagsIndex(boolean enable) {
        this.compositeConfiguration.setProperty(PropertyList.RENDER_TAGS_INDEX.getKey(), (Object)enable);
    }

    @Override
    public boolean getSanitizeTag() {
        return this.getAsBoolean(PropertyList.TAG_SANITIZE.getKey());
    }

    @Override
    public int getServerPort() {
        return this.getAsInt(PropertyList.SERVER_PORT.getKey(), 8080);
    }

    public void setServerPort(int port) {
        this.setProperty(PropertyList.SERVER_PORT.getKey(), port);
    }

    @Override
    public String getSiteHost() {
        return this.getAsString(PropertyList.SITE_HOST.getKey(), "http://www.jbake.org");
    }

    public void setSiteHost(String siteHost) {
        this.setProperty(PropertyList.SITE_HOST.getKey(), siteHost);
    }

    @Override
    public String getSiteMapFileName() {
        return this.getAsString(PropertyList.SITEMAP_FILE.getKey());
    }

    @Override
    public File getSourceFolder() {
        return this.getAsFolder(SOURCE_FOLDER_KEY);
    }

    public void setSourceFolder(File sourceFolder) {
        this.setProperty(SOURCE_FOLDER_KEY, sourceFolder);
        this.setupPaths();
    }

    @Override
    public String getTagPathName() {
        return this.getAsString(PropertyList.TAG_PATH.getKey());
    }

    @Override
    public String getTemplateEncoding() {
        return this.getAsString(PropertyList.TEMPLATE_ENCODING.getKey());
    }

    @Override
    public File getTemplateFileByDocType(String docType) {
        String templateKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_FILE_POSTFIX;
        String templateFileName = this.getAsString(templateKey);
        if (templateFileName != null) {
            return new File(this.getTemplateFolder(), templateFileName);
        }
        this.logger.warn("Cannot find configuration key '{}' for document type '{}'", (Object)templateKey, (Object)docType);
        return null;
    }

    @Override
    public File getTemplateFolder() {
        return this.getAsFolder(TEMPLATE_FOLDER_KEY);
    }

    public void setTemplateFolder(File templateFolder) {
        if (templateFolder != null) {
            this.setProperty(TEMPLATE_FOLDER_KEY, templateFolder);
        }
    }

    @Override
    public String getTemplateFolderName() {
        return this.getAsString(PropertyList.TEMPLATE_FOLDER.getKey());
    }

    @Override
    public String getThymeleafLocale() {
        return this.getAsString(PropertyList.THYMELEAF_LOCALE.getKey());
    }

    @Override
    public boolean getUriWithoutExtension() {
        return this.getAsBoolean(PropertyList.URI_NO_EXTENSION.getKey());
    }

    public void setUriWithoutExtension(boolean withoutExtension) {
        this.setProperty(PropertyList.URI_NO_EXTENSION.getKey(), withoutExtension);
    }

    @Override
    public String getVersion() {
        return this.getAsString(PropertyList.VERSION.getKey());
    }

    public void setDestinationFolderName(String folderName) {
        this.setProperty(PropertyList.DESTINATION_FOLDER.getKey(), folderName);
        this.setupDefaultDestination();
    }

    public void setExampleProject(String type, String fileName) {
        String projectKey = "example.project." + type;
        this.setProperty(projectKey, fileName);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.compositeConfiguration.setProperty(key, value);
    }

    @Override
    public String getThymeleafModeByType(String type) {
        String key = "template_" + type + "_thymeleaf_mode";
        return this.getAsString(key, DEFAULT_TYHMELEAF_TEMPLATE_MODE);
    }

    @Override
    public String getServerContextPath() {
        return this.getAsString(PropertyList.SERVER_CONTEXT_PATH.getKey());
    }

    @Override
    public String getServerHostname() {
        return this.getAsString(PropertyList.SERVER_HOSTNAME.getKey());
    }

    @Override
    public Map<String, Object> asHashMap() {
        HashMap<String, Object> configModel = new HashMap<String, Object>();
        Iterator<String> configKeys = this.getKeys();
        while (configKeys.hasNext()) {
            String key = configKeys.next();
            Object valueObject = key.equals(PropertyList.PAGINATE_INDEX.getKey()) ? Boolean.valueOf(this.getPaginateIndex()) : this.get(key);
            configModel.put(key.replace(".", "_"), valueObject);
        }
        return configModel;
    }

    public void setTemplateExtensionForDocType(String docType, String extension) {
        String templateExtensionKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_EXTENSION_POSTFIX;
        this.setProperty(templateExtensionKey, extension);
    }

    public void setTemplateFileNameForDocType(String docType, String fileName) {
        String templateKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_FILE_POSTFIX;
        this.setProperty(templateKey, fileName);
    }

    private void setupPaths() {
        this.setupDefaultDestination();
        this.setupDefaultAssetFolder();
        this.setupDefaultTemplateFolder();
        this.setupDefaultContentFolder();
        this.setupDefaultDataFolder();
    }

    private void setupDefaultDestination() {
        String destinationPath = this.getAsString(PropertyList.DESTINATION_FOLDER.getKey());
        File destination = new File(destinationPath);
        if (destination.isAbsolute()) {
            this.setDestinationFolder(destination);
        } else {
            this.setDestinationFolder(new File(this.getSourceFolder(), destinationPath));
        }
    }

    private void setupDefaultAssetFolder() {
        String assetFolder = this.getAsString(PropertyList.ASSET_FOLDER.getKey());
        File asset = new File(assetFolder);
        if (asset.isAbsolute()) {
            this.setAssetFolder(asset);
        } else {
            this.setAssetFolder(new File(this.getSourceFolder(), assetFolder));
        }
    }

    private void setupDefaultTemplateFolder() {
        String templateFolder = this.getAsString(PropertyList.TEMPLATE_FOLDER.getKey());
        File template = new File(templateFolder);
        if (template.isAbsolute()) {
            this.setTemplateFolder(template);
        } else {
            this.setTemplateFolder(new File(this.getSourceFolder(), templateFolder));
        }
    }

    private void setupDefaultDataFolder() {
        String dataFolder = this.getAsString(PropertyList.DATA_FOLDER.getKey());
        File data = new File(dataFolder);
        if (data.isAbsolute()) {
            this.setDataFolder(data);
        } else {
            this.setDataFolder(new File(this.getSourceFolder(), dataFolder));
        }
    }

    private void setupDefaultContentFolder() {
        this.setContentFolder(new File(this.getSourceFolder(), this.getContentFolderName()));
    }

    @Override
    public String getHeaderSeparator() {
        return this.getAsString(PropertyList.HEADER_SEPARATOR.getKey());
    }

    public void setHeaderSeparator(String headerSeparator) {
        this.setProperty(PropertyList.HEADER_SEPARATOR.getKey(), headerSeparator);
    }

    @Override
    public boolean getImgPathPrependHost() {
        return this.getAsBoolean(PropertyList.IMG_PATH_PREPEND_HOST.getKey());
    }

    public void setImgPathPrependHost(boolean imgPathPrependHost) {
        this.setProperty(PropertyList.IMG_PATH_PREPEND_HOST.getKey(), imgPathPrependHost);
    }

    @Override
    public boolean getImgPathUpdate() {
        return this.getAsBoolean(PropertyList.IMG_PATH_UPDATE.getKey());
    }

    public void setImgPathUPdate(boolean imgPathUpdate) {
        this.setProperty(PropertyList.IMG_PATH_UPDATE.getKey(), imgPathUpdate);
    }

    @Override
    public List<Property> getJbakeProperties() {
        ArrayList<Property> jbakeKeys = new ArrayList<Property>();
        for (int i = 0; i < this.compositeConfiguration.getNumberOfConfigurations(); ++i) {
            Configuration configuration = this.compositeConfiguration.getConfiguration(i);
            if (configuration instanceof SystemConfiguration) continue;
            Iterator it = configuration.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Property property = PropertyList.getPropertyByKey(key);
                if (jbakeKeys.contains(property)) continue;
                jbakeKeys.add(property);
            }
        }
        Collections.sort(jbakeKeys);
        return jbakeKeys;
    }

    @Override
    public void addConfiguration(Properties properties) {
        this.compositeConfiguration.addConfiguration((Configuration)new MapConfiguration(properties));
    }

    @Override
    public String getAbbreviatedGitHash() {
        return this.getAsString(PropertyList.GIT_HASH.getKey());
    }

    @Override
    public String getJvmLocale() {
        return this.getAsString(PropertyList.JVM_LOCALE.getKey());
    }
}

