/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.io.File;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.ConfigUtil;
import org.jbake.app.configuration.DefaultJBakeConfiguration;

public class JBakeConfigurationFactory {
    private ConfigUtil configUtil = new ConfigUtil();

    public DefaultJBakeConfiguration createDefaultJbakeConfiguration(File sourceFolder, File destination, boolean isClearCache) throws JBakeException {
        return this.createDefaultJbakeConfiguration(sourceFolder, destination, (File)null, isClearCache);
    }

    public DefaultJBakeConfiguration createDefaultJbakeConfiguration(File sourceFolder, File destination, File propertiesFile, boolean isClearCache) throws JBakeException {
        DefaultJBakeConfiguration configuration = (DefaultJBakeConfiguration)this.getConfigUtil().loadConfig(sourceFolder, propertiesFile);
        configuration.setDestinationFolder(destination);
        configuration.setClearCache(isClearCache);
        return configuration;
    }

    @Deprecated
    public DefaultJBakeConfiguration createDefaultJbakeConfiguration(File sourceFolder, File destination, CompositeConfiguration compositeConfiguration, boolean isClearCache) throws JBakeException {
        DefaultJBakeConfiguration configuration = new DefaultJBakeConfiguration(sourceFolder, compositeConfiguration);
        configuration.setDestinationFolder(destination);
        configuration.setClearCache(isClearCache);
        return configuration;
    }

    @Deprecated
    public DefaultJBakeConfiguration createDefaultJbakeConfiguration(File sourceFolder, File destination, CompositeConfiguration compositeConfiguration) throws JBakeException {
        DefaultJBakeConfiguration configuration = new DefaultJBakeConfiguration(sourceFolder, compositeConfiguration);
        configuration.setDestinationFolder(destination);
        return configuration;
    }

    @Deprecated
    public DefaultJBakeConfiguration createDefaultJbakeConfiguration(File sourceFolder, CompositeConfiguration config) throws JBakeException {
        return new DefaultJBakeConfiguration(sourceFolder, config);
    }

    @Deprecated
    public DefaultJBakeConfiguration createJettyJbakeConfiguration(File sourceFolder, File destinationFolder, boolean isClearCache) throws JBakeException {
        return this.createJettyJbakeConfiguration(sourceFolder, destinationFolder, null, isClearCache);
    }

    public DefaultJBakeConfiguration createJettyJbakeConfiguration(File sourceFolder, File destinationFolder, File propertiesFile, boolean isClearCache) throws JBakeException {
        DefaultJBakeConfiguration configuration = (DefaultJBakeConfiguration)this.getConfigUtil().loadConfig(sourceFolder, propertiesFile);
        configuration.setDestinationFolder(destinationFolder);
        configuration.setClearCache(isClearCache);
        configuration.setSiteHost("http://" + configuration.getServerHostname() + ":" + configuration.getServerPort() + configuration.getServerContextPath());
        return configuration;
    }

    public ConfigUtil getConfigUtil() {
        return this.configUtil;
    }

    public void setConfigUtil(ConfigUtil configUtil) {
        this.configUtil = configUtil;
    }

    public JBakeConfigurationFactory setEncoding(String charset) {
        this.configUtil.setEncoding(charset);
        return this;
    }
}

