/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.launcher.CustomFSChangeListener;
import org.jbake.launcher.LaunchOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BakeWatcher {
    private final Logger logger = LoggerFactory.getLogger(BakeWatcher.class);

    @Deprecated
    public void start(LaunchOptions res, CompositeConfiguration config) {
        DefaultJBakeConfiguration configuration = new JBakeConfigurationFactory().createDefaultJbakeConfiguration(res.getSource(), config);
        this.start(configuration);
    }

    public void start(JBakeConfiguration config) {
        try {
            FileSystemManager fsMan = VFS.getManager();
            FileObject listenPath = fsMan.resolveFile(config.getContentFolder().toURI());
            FileObject templateListenPath = fsMan.resolveFile(config.getTemplateFolder().toURI());
            FileObject assetPath = fsMan.resolveFile(config.getAssetFolder().toURI());
            FileObject dataPath = fsMan.resolveFile(config.getDataFolder().toURI());
            this.logger.info("Watching for (content, data, template, asset) changes in [{}]", (Object)config.getSourceFolder().getPath());
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new CustomFSChangeListener(config));
            monitor.setRecursive(true);
            monitor.addFile(listenPath);
            monitor.addFile(templateListenPath);
            monitor.addFile(assetPath);
            monitor.addFile(dataPath);
            monitor.start();
        }
        catch (FileSystemException e) {
            this.logger.error("Problems watching filesystem changes", (Throwable)e);
        }
    }
}

