/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.PrintStream;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.launcher.BakeWatcher;
import org.jbake.launcher.Baker;
import org.jbake.launcher.Init;
import org.jbake.launcher.JettyServer;
import org.jbake.launcher.LaunchOptions;
import org.jbake.launcher.SystemExit;
import org.jbake.util.ConfigurationPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import picocli.CommandLine;

public class Main {
    private static final String USAGE_PREFIX = "Usage: jbake";
    private static final String ALT_USAGE_PREFIX = "   or  jbake";
    private final Baker baker;
    private final JettyServer jettyServer;
    private final BakeWatcher watcher;
    private JBakeConfigurationFactory configurationFactory;
    private static final Logger logger = LoggerFactory.getLogger((String)"jbake");

    public Main() {
        this(new Baker(), new JettyServer(), new BakeWatcher());
    }

    protected Main(Baker baker, JettyServer jetty, BakeWatcher watcher) {
        this.baker = baker;
        this.jettyServer = jetty;
        this.watcher = watcher;
        this.configurationFactory = new JBakeConfigurationFactory();
    }

    public static void main(String[] args) {
        try {
            new Main().run(args);
        }
        catch (JBakeException e) {
            logger.error(e.getMessage());
            logger.trace(e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof CommandLine.MissingParameterException) {
                Main.printUsage();
            }
            System.exit(e.getExit());
        }
    }

    public void run(String[] args) throws JBakeException {
        try {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            LaunchOptions res = this.parseArguments(args);
            DefaultJBakeConfiguration config = res.isRunServer() ? this.getJBakeConfigurationFactory().setEncoding(res.getPropertiesEncoding()).createJettyJbakeConfiguration(res.getSource(), res.getDestination(), res.getConfig(), res.isClearCache()) : this.getJBakeConfigurationFactory().setEncoding(res.getPropertiesEncoding()).createDefaultJbakeConfiguration(res.getSource(), res.getDestination(), res.getConfig(), res.isClearCache());
            this.run(res, config);
        }
        catch (JBakeException e) {
            throw e;
        }
        catch (CommandLine.MissingParameterException mex) {
            throw new JBakeException(SystemExit.CONFIGURATION_ERROR, mex.getMessage(), mex);
        }
        catch (Throwable e) {
            throw new JBakeException(SystemExit.ERROR, "An unexpected error occurred: " + e.getMessage(), e);
        }
    }

    protected void run(LaunchOptions res, JBakeConfiguration config) {
        System.out.println("JBake " + config.getVersion() + " (" + config.getBuildTimeStamp() + " " + config.getAbbreviatedGitHash() + "#) [http://jbake.org]");
        System.out.println();
        if (res.isHelpNeeded()) {
            this.printUsage(res);
            return;
        }
        if (res.isListConfig()) {
            ConfigurationPrinter printer = new ConfigurationPrinter(config, System.out);
            printer.print();
            return;
        }
        if (res.isBake()) {
            this.baker.bake(config);
        }
        if (res.isInit()) {
            this.initStructure(res.getTemplate(), config);
        }
        if (res.isRunServer()) {
            this.watcher.start(config);
            if (res.isBake()) {
                if (res.getDestination() != null) {
                    this.runServer(res.getDestination(), config);
                } else if (!res.getSource().getPath().equals(".")) {
                    this.runServer(res.getSource(), config);
                } else {
                    this.runServer(config.getDestinationFolder(), config);
                }
            } else {
                this.runServer(config.getDestinationFolder(), config);
            }
        }
    }

    private LaunchOptions parseArguments(String[] args) {
        return (LaunchOptions)CommandLine.populateCommand((Object)new LaunchOptions(), (String[])args);
    }

    private void printUsage(Object options) {
        CommandLine cli = new CommandLine(options);
        cli.setUsageHelpLongOptionsMaxWidth(28);
        cli.usage(System.out);
    }

    public static void printUsage() {
        CommandLine.usage((Object)new LaunchOptions(), (PrintStream)System.out);
    }

    private void runServer(File path, JBakeConfiguration configuration) {
        this.jettyServer.run(path.getPath(), configuration);
    }

    private void initStructure(String type, JBakeConfiguration config) {
        Init init = new Init(config);
        try {
            File templateFolder = FileUtil.getRunningLocation();
            File outputFolder = config.getSourceFolder() != null ? config.getSourceFolder() : new File(".");
            init.run(outputFolder, templateFolder, type);
            System.out.println("Base folder structure successfully created.");
        }
        catch (Exception e) {
            String msg = "Failed to initialise structure: " + e.getMessage();
            throw new JBakeException(SystemExit.INIT_ERROR, msg, e);
        }
    }

    public JBakeConfigurationFactory getJBakeConfigurationFactory() {
        return this.configurationFactory;
    }

    public void setJBakeConfigurationFactory(JBakeConfigurationFactory factory) {
        this.configurationFactory = factory;
    }
}

