/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.IOUtils;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.parser.ParserContext;
import org.jbake.parser.ParserEngine;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupEngine
implements ParserEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkupEngine.class);
    private static final String UTF_8_BOM = "\ufeff";
    private JBakeConfiguration configuration;

    public boolean validate(ParserContext context) {
        return true;
    }

    public void processHeader(ParserContext context) {
    }

    public void processBody(ParserContext context) {
    }

    @Override
    public Map<String, Object> parse(Configuration config, File file, String contentPath) {
        return this.parse(new DefaultJBakeConfiguration((CompositeConfiguration)config), file);
    }

    @Override
    public DocumentModel parse(JBakeConfiguration config, File file) {
        this.configuration = config;
        List<String> fileContent = this.getFileContent(file, config.getRenderEncoding());
        if (fileContent.isEmpty()) {
            return null;
        }
        boolean hasHeader = this.hasHeader(fileContent);
        ParserContext context = new ParserContext(file, fileContent, config, hasHeader);
        this.processDefaultHeader(context);
        this.processHeader(context);
        this.setModelDefaultsIfNotSetInHeader(context);
        this.sanitizeTags(context);
        if (context.getType().isEmpty() || context.getStatus().isEmpty()) {
            LOGGER.warn("Parsing skipped (missing type or status value in header meta data) for file {}!", (Object)file);
            return null;
        }
        this.processDefaultBody(context);
        if (!this.validate(context)) {
            LOGGER.error("Incomplete source file ({}) for markup engine: {}", (Object)file, (Object)this.getClass().getSimpleName());
            return null;
        }
        this.processBody(context);
        return context.getDocumentModel();
    }

    private List<String> getFileContent(File file, String encoding) {
        List list;
        FileInputStream is = new FileInputStream(file);
        try {
            LOGGER.debug("read file '{}' with encoding '{}'", (Object)file, (Object)encoding);
            List lines = IOUtils.readLines((InputStream)is, (String)encoding);
            if (!lines.isEmpty() && this.isUtf8WithBOM(encoding, (String)lines.get(0))) {
                LOGGER.warn("remove BOM from file '{}' read with encoding '{}'", (Object)file, (Object)encoding);
                lines.set(0, ((String)lines.get(0)).replace(UTF_8_BOM, ""));
            }
            list = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Error while opening file {}", (Object)file, (Object)e);
                return Collections.emptyList();
            }
        }
        ((InputStream)is).close();
        return list;
    }

    private boolean isUtf8WithBOM(String encoding, String line) {
        return encoding.equals("UTF-8") && line.startsWith(UTF_8_BOM);
    }

    private void sanitizeTags(ParserContext context) {
        if (context.getTags() != null) {
            String[] tags = (String[])context.getTags();
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = this.sanitize(tags[i]);
                if (!context.getConfig().getSanitizeTag()) continue;
                tags[i] = tags[i].replace(" ", "-");
            }
            context.setTags(tags);
        }
    }

    private void setModelDefaultsIfNotSetInHeader(ParserContext context) {
        if (context.getDate() == null) {
            context.setDate(new Date(context.getFile().lastModified()));
        }
        if (context.getConfig().getDefaultStatus() != null && context.getStatus().isEmpty()) {
            context.setDefaultStatus();
        }
        if (context.getConfig().getDefaultType() != null && context.getType().isEmpty()) {
            context.setDefaultType();
        }
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = true;
        boolean statusFound = false;
        boolean typeFound = false;
        if (!this.headerSeparatorDemarcatesHeader(contents)) {
            return false;
        }
        for (String line : contents) {
            if (this.hasHeaderSeparator(line)) {
                LOGGER.debug("Header separator found");
                break;
            }
            if (this.isTypeProperty(line)) {
                LOGGER.debug("Type property found");
                typeFound = true;
            }
            if (this.isStatusProperty(line)) {
                LOGGER.debug("Status property found");
                statusFound = true;
            }
            if (line.isEmpty() || line.contains("=")) continue;
            LOGGER.error("Property found without assignment [{}]", (Object)line);
            headerValid = false;
        }
        return !(!headerValid || !statusFound && !this.hasDefaultStatus() || !typeFound && !this.hasDefaultType());
    }

    private boolean hasDefaultType() {
        return !this.configuration.getDefaultType().isEmpty();
    }

    private boolean hasDefaultStatus() {
        return !this.configuration.getDefaultStatus().isEmpty();
    }

    private boolean headerSeparatorDemarcatesHeader(List<String> contents) {
        List<String> subContents = null;
        int index = contents.indexOf(this.configuration.getHeaderSeparator());
        if (index != -1) {
            subContents = contents.subList(0, index);
            for (String line : subContents) {
                if (line.contains("=") || line.isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasHeaderSeparator(String line) {
        return this.sanitize(line).equals(this.configuration.getHeaderSeparator());
    }

    private boolean isStatusProperty(String line) {
        return this.sanitize(line).startsWith("status=");
    }

    private boolean isTypeProperty(String line) {
        return this.sanitize(line).startsWith("type=");
    }

    private void processDefaultHeader(ParserContext context) {
        if (context.hasHeader()) {
            for (String line : context.getFileLines()) {
                if (this.hasHeaderSeparator(line)) break;
                this.processHeaderLine(line, context.getDocumentModel());
            }
        }
    }

    private void processHeaderLine(String line, DocumentModel content) {
        String[] parts = line.split("=", 2);
        if (!line.isEmpty() && parts.length == 2) {
            this.storeHeaderValue(parts[0], parts[1], content);
        }
    }

    void storeHeaderValue(String inputKey, String inputValue, DocumentModel content) {
        String key = this.sanitize(inputKey);
        String value = this.sanitize(inputValue);
        if (key.equalsIgnoreCase("date")) {
            SimpleDateFormat df = new SimpleDateFormat(this.configuration.getDateFormat());
            try {
                Date date = df.parse(value);
                content.setDate(date);
            }
            catch (ParseException e) {
                LOGGER.error("unable to parse date {}", (Object)value);
            }
        } else if (key.equalsIgnoreCase("tags")) {
            content.setTags(this.getTags(value));
        } else if (key.equalsIgnoreCase("cached")) {
            content.setCached(Boolean.valueOf(value));
        } else if (this.isJson(value)) {
            content.put(key, JSONValue.parse((String)value));
        } else {
            content.put(key, value);
        }
    }

    private String sanitize(String part) {
        return part.trim();
    }

    private String[] getTags(String tagsPart) {
        return tagsPart.split(",");
    }

    private boolean isJson(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    private void processDefaultBody(ParserContext context) {
        StringBuilder body = new StringBuilder();
        boolean inBody = false;
        for (String line : context.getFileLines()) {
            if (inBody) {
                body.append(line).append("\n");
            }
            if (!line.equals(this.configuration.getHeaderSeparator())) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : context.getFileLines()) {
                body.append(line).append("\n");
            }
        }
        context.setBody(body.toString());
    }
}

