/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;

public class ParserContext {
    private final File file;
    private final List<String> fileLines;
    private final JBakeConfiguration config;
    private final boolean hasHeader;
    private final DocumentModel documentModel;

    public ParserContext(File file, List<String> fileLines, JBakeConfiguration config, boolean hasHeader) {
        this.file = file;
        this.fileLines = fileLines;
        this.config = config;
        this.hasHeader = hasHeader;
        this.documentModel = DocumentModel.createDefaultDocumentModel();
    }

    public File getFile() {
        return this.file;
    }

    public List<String> getFileLines() {
        return this.fileLines;
    }

    public JBakeConfiguration getConfig() {
        return this.config;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public String getBody() {
        return this.documentModel.getBody();
    }

    public void setBody(String str) {
        this.documentModel.setBody(str);
    }

    public Date getDate() {
        return this.getDocumentModel().getDate();
    }

    public void setDate(Date date) {
        this.getDocumentModel().setDate(date);
    }

    public String getStatus() {
        if (this.getDocumentModel().getStatus() != null) {
            return this.getDocumentModel().getStatus();
        }
        return "";
    }

    public void setDefaultStatus() {
        this.getDocumentModel().setStatus(this.getConfig().getDefaultStatus());
    }

    public String getType() {
        if (this.getDocumentModel().getType() != null) {
            return this.getDocumentModel().getType();
        }
        return "";
    }

    public void setDefaultType() {
        this.getDocumentModel().setType(this.getConfig().getDefaultType());
    }

    public Object getTags() {
        return this.getDocumentModel().getTags();
    }

    public void setTags(String[] tags) {
        this.getDocumentModel().setTags(tags);
    }
}

