/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlEngine
extends MarkupEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlEngine.class);
    public static final String JBAKE_PREFIX = "jbake-";

    private DocumentModel parseFile(File file) {
        DocumentModel model = new DocumentModel();
        Yaml yaml = new Yaml();
        try (FileInputStream is = new FileInputStream(file);){
            Object result = yaml.load((InputStream)is);
            if (result instanceof List) {
                model.put("data", result);
            } else if (result instanceof Map) {
                model.putAll((Map)result);
            } else {
                LOGGER.warn("Unexpected result [{}] while parsing YAML file {}", result.getClass(), (Object)file);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing YAML file {}", (Object)file, (Object)e);
        }
        return model;
    }

    @Override
    public DocumentModel parse(JBakeConfiguration config, File file) {
        return this.parseFile(file);
    }

    @Override
    public void processHeader(ParserContext context) {
        DocumentModel fileContents = this.parseFile(context.getFile());
        DocumentModel documentModel = context.getDocumentModel();
        for (String key : fileContents.keySet()) {
            if (this.hasJBakePrefix(key)) {
                String pKey = key.substring(6);
                documentModel.put(pKey, fileContents.get(key));
                continue;
            }
            documentModel.put(key, fileContents.get(key));
        }
    }

    @Override
    public void processBody(ParserContext context) {
        context.setBody("");
    }

    private boolean hasJBakePrefix(String key) {
        return key.startsWith(JBAKE_PREFIX);
    }
}

