/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import java.util.LinkedList;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.Renderer;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class DocumentsRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, JBakeConfiguration config) throws RenderingException {
        int renderedCount = 0;
        int index = 0;
        LinkedList<String> errors = new LinkedList<String>();
        DocumentModel nextDocument = null;
        DocumentList<DocumentModel> documentList = db.getUnrenderedContent();
        for (DocumentModel document : documentList) {
            try {
                DocumentModel tempNext;
                document.setNextContent(null);
                document.setPreviousContent(null);
                if (nextDocument != null && index > 0) {
                    document.setNextContent(this.getContentForNav(nextDocument));
                }
                if (index < documentList.size() - 1 && (tempNext = this.findPrevPublishedDocument(documentList, index)) != null) {
                    document.setPreviousContent(this.getContentForNav(tempNext));
                }
                if (this.isPublished(document)) {
                    nextDocument = document;
                }
                renderer.render(document);
                db.markContentAsRendered(document);
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
            ++index;
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render documents. Cause(s):");
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            throw new RenderingException(sb.toString());
        }
        return renderedCount;
    }

    private DocumentModel findPrevPublishedDocument(DocumentList<DocumentModel> documentList, int index) {
        for (int prevDocIndex = index + 1; prevDocIndex < documentList.size(); ++prevDocIndex) {
            DocumentModel prevDocument = (DocumentModel)documentList.get(prevDocIndex);
            if (!this.isPublished(prevDocument)) continue;
            return prevDocument;
        }
        return null;
    }

    private boolean isPublished(DocumentModel document) {
        return "published".equals(document.getStatus());
    }

    private DocumentModel getContentForNav(DocumentModel document) {
        DocumentModel navDocument = new DocumentModel();
        navDocument.setNoExtensionUri(document.getNoExtensionUri());
        navDocument.setUri(document.getUri());
        navDocument.setTitle(document.getTitle());
        return navDocument;
    }

    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        return this.render(renderer, db, null);
    }
}

