/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import java.io.File;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.jbake.template.model.TemplateModel;

public class GroovyMarkupTemplateEngine
extends AbstractTemplateEngine {
    private TemplateConfiguration templateConfiguration;
    private MarkupTemplateEngine templateEngine;

    @Deprecated
    public GroovyMarkupTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
        this.setupTemplateConfiguration();
        this.initializeTemplateEngine();
    }

    public GroovyMarkupTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.setupTemplateConfiguration();
        this.initializeTemplateEngine();
    }

    private void setupTemplateConfiguration() {
        this.templateConfiguration = new TemplateConfiguration();
        this.templateConfiguration.setUseDoubleQuotes(true);
        this.templateConfiguration.setAutoIndent(true);
        this.templateConfiguration.setAutoNewLine(true);
        this.templateConfiguration.setAutoEscape(true);
    }

    private void initializeTemplateEngine() {
        this.templateEngine = new MarkupTemplateEngine(MarkupTemplateEngine.class.getClassLoader(), this.config.getTemplateFolder(), this.templateConfiguration);
    }

    @Override
    public void renderDocument(TemplateModel model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.templateEngine.createTemplateByPath(templateName);
            TemplateModel wrappedModel = this.wrap(model);
            Writable writable = template.make((Map)wrappedModel);
            writable.writeTo(writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }

    private TemplateModel wrap(final TemplateModel model) {
        return new TemplateModel(model){

            @Override
            public Object get(Object key) {
                try {
                    return AbstractTemplateEngine.extractors.extractAndTransform(GroovyMarkupTemplateEngine.this.db, (String)key, model, new TemplateEngineAdapter.NoopAdapter());
                }
                catch (NoModelExtractorException e) {
                    return super.get(key);
                }
            }
        };
    }
}

