/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.filter.CDATAFilter;
import de.neuland.jade4j.filter.CssFilter;
import de.neuland.jade4j.filter.Filter;
import de.neuland.jade4j.filter.JsFilter;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.template.FileTemplateLoader;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.jbake.template.model.TemplateModel;

public class JadeTemplateEngine
extends AbstractTemplateEngine {
    private static final String FILTER_CDATA = "cdata";
    private static final String FILTER_STYLE = "css";
    private static final String FILTER_SCRIPT = "js";
    private final JadeConfiguration jadeConfiguration = new JadeConfiguration();

    @Deprecated
    public JadeTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
    }

    public JadeTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        FileTemplateLoader loader = new FileTemplateLoader(config.getTemplateFolder().getPath() + File.separatorChar, config.getTemplateEncoding());
        this.jadeConfiguration.setTemplateLoader((TemplateLoader)loader);
        this.jadeConfiguration.setMode(Jade4J.Mode.XHTML);
        this.jadeConfiguration.setPrettyPrint(true);
        this.jadeConfiguration.setFilter(FILTER_CDATA, (Filter)new CDATAFilter());
        this.jadeConfiguration.setFilter(FILTER_SCRIPT, (Filter)new JsFilter());
        this.jadeConfiguration.setFilter(FILTER_STYLE, (Filter)new CssFilter());
        this.jadeConfiguration.getSharedVariables().put("formatter", new FormatHelper());
    }

    @Override
    public void renderDocument(TemplateModel model, String templateName, Writer writer) throws RenderingException {
        try {
            JadeTemplate template = this.jadeConfiguration.getTemplate(templateName);
            this.renderTemplate(template, model, writer);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
    }

    public void renderTemplate(JadeTemplate template, TemplateModel model, Writer writer) {
        JadeModel jadeModel = this.wrap(model);
        jadeModel.putAll(this.jadeConfiguration.getSharedVariables());
        template.process(jadeModel, writer);
    }

    private JadeModel wrap(TemplateModel model) {
        return new JadeModel(model){

            public Object get(Object property) {
                try {
                    return AbstractTemplateEngine.extractors.extractAndTransform(JadeTemplateEngine.this.db, (String)property, (Map)((Object)this), new TemplateEngineAdapter.NoopAdapter());
                }
                catch (NoModelExtractorException e) {
                    return super.get(property);
                }
            }
        };
    }

    public static class FormatHelper {
        private final Map<String, SimpleDateFormat> formatters = new HashMap<String, SimpleDateFormat>();

        public String format(Date date, String pattern) {
            if (date != null && pattern != null) {
                SimpleDateFormat df = this.formatters.get(pattern);
                if (df == null) {
                    df = new SimpleDateFormat(pattern);
                    this.formatters.put(pattern, df);
                }
                return df.format(date);
            }
            return "";
        }

        public String escape(String s) {
            return StringEscapeUtils.escapeHtml((String)s);
        }
    }
}

