/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template.model;

import java.util.Map;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.configuration.PropertyList;
import org.jbake.template.ModelExtractor;
import org.jbake.template.model.TemplateModel;

public class TagsExtractor
implements ModelExtractor<DocumentList> {
    @Override
    public DocumentList get(ContentStore db, Map model, String key) {
        DocumentList dl = new DocumentList();
        TemplateModel templateModel = new TemplateModel();
        templateModel.putAll(model);
        Map<String, Object> config = templateModel.getConfig();
        String tagPath = config.get(PropertyList.TAG_PATH.getKey().replace(".", "_")).toString();
        for (String tag : db.getAllTags()) {
            TemplateModel newTag = new TemplateModel();
            String tagName = tag;
            newTag.setName(tagName);
            String uri = tagPath + "/" + tag + config.get(PropertyList.OUTPUT_EXTENSION.getKey().replace(".", "_")).toString();
            newTag.setUri(uri);
            newTag.setTaggedPosts(db.getPublishedPostsByTag(tagName));
            newTag.setTaggedDocuments(db.getPublishedDocumentsByTag(tagName));
            dl.push(newTag);
        }
        return dl;
    }
}

