/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.util;

import java.io.PrintStream;
import java.util.List;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.Property;

public class ConfigurationPrinter {
    private PrintStream out;
    private JBakeConfiguration configuration;

    public ConfigurationPrinter(JBakeConfiguration configuration, PrintStream out) {
        this.out = out;
        this.configuration = configuration;
    }

    public void print() {
        List<Property> properties = this.configuration.getJbakeProperties();
        Property.Group lastGroup = null;
        for (Property property : properties) {
            if (lastGroup != property.getGroup()) {
                this.printGroup(property);
                this.printHeader();
            }
            if (!property.getDescription().isEmpty()) {
                this.printDescription(property);
            }
            this.printKeyAndValue(property);
            lastGroup = property.getGroup();
        }
    }

    private void printHeader() {
        this.out.printf("%1$-40s %2$-40s%n", "Key", "Value");
        this.out.println(this.getHorizontalLine());
    }

    private String getHorizontalLine() {
        return String.format("%080d%n", 0).replace("0", "-");
    }

    private void printGroup(Property property) {
        this.out.printf("%n%s - Settings%n%n", new Object[]{property.getGroup()});
    }

    private void printDescription(Property property) {
        this.out.printf("# %s%n", property.getDescription());
    }

    private void printKeyAndValue(Property property) {
        String key = this.leftFillWithDots(property.getKey());
        Object value = this.configuration.get(property.getKey());
        this.out.printf("%1$s: %2$-40s%n%n", key, value);
    }

    private String leftFillWithDots(String value) {
        return String.format("%1$-40s", value).replace(' ', '.');
    }
}

