/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.util;

import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlUtil {
    private HtmlUtil() {
    }

    public static void fixImageSourceUrls(DocumentModel fileContents, JBakeConfiguration configuration) {
        String htmlContent = fileContents.getBody();
        boolean prependSiteHost = configuration.getImgPathPrependHost();
        String siteHost = configuration.getSiteHost();
        String uri = HtmlUtil.getDocumentUri(fileContents);
        Document document = Jsoup.parseBodyFragment((String)htmlContent);
        Elements allImgs = document.getElementsByTag("img");
        for (Element img : allImgs) {
            HtmlUtil.transformImageSource(img, uri, siteHost, prependSiteHost);
        }
        fileContents.setBody(document.body().html());
    }

    private static String getDocumentUri(DocumentModel fileContents) {
        String uri = fileContents.getUri();
        if (fileContents.getNoExtensionUri() != null) {
            uri = fileContents.getNoExtensionUri();
            uri = HtmlUtil.removeTrailingSlash(uri);
        }
        if (uri.contains("/")) {
            uri = HtmlUtil.removeFilename(uri);
        }
        return uri;
    }

    private static void transformImageSource(Element img, String uri, String siteHost, boolean prependSiteHost) {
        String source = img.attr("src");
        if (!source.startsWith("http://") && !source.startsWith("https://")) {
            if (HtmlUtil.isRelative(source)) {
                source = uri + source.replaceFirst("\\./", "");
            }
            if (prependSiteHost) {
                if (!siteHost.endsWith("/") && HtmlUtil.isRelative(source)) {
                    siteHost = siteHost.concat("/");
                }
                source = siteHost + source;
            }
            img.attr("src", source);
        }
    }

    private static String removeFilename(String uri) {
        uri = uri.substring(0, uri.lastIndexOf(47) + 1);
        return uri;
    }

    private static String removeTrailingSlash(String uri) {
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private static boolean isRelative(String source) {
        return !source.startsWith("/");
    }
}

