/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.jbake.app.JBakeException;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.launcher.SystemExit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyServer.class);
    private Server server;

    @Deprecated
    public void run(String resourceBase, String port) {
        LOGGER.warn("DEPRECATED. This method will be removed in the next major release. Use run(String resourceBase, JBakeConfiguration config) instead.");
        this.run(resourceBase, "/", "localhost", Integer.parseInt(port));
    }

    public void run(String resourceBase, JBakeConfiguration configuration) {
        this.run(resourceBase, configuration.getServerContextPath(), configuration.getServerHostname(), configuration.getServerPort());
    }

    private void run(String resourceBase, String contextPath, String hostname, int port) {
        try {
            this.server = new Server();
            ServerConnector connector = new ServerConnector(this.server);
            connector.setHost(hostname);
            connector.setPort(port);
            this.server.addConnector((Connector)connector);
            ResourceHandler resource_handler = new ResourceHandler();
            resource_handler.setDirectoriesListed(true);
            resource_handler.setWelcomeFiles(new String[]{"index", "index.html"});
            resource_handler.setResourceBase(resourceBase);
            ContextHandler contextHandler = new ContextHandler();
            contextHandler.setContextPath(contextPath);
            contextHandler.setHandler((Handler)resource_handler);
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{contextHandler, new DefaultHandler()});
            this.server.setHandler((Handler)handlers);
            LOGGER.info("Serving out contents of: [{}] on http://{}:{}{}", new Object[]{resourceBase, hostname, port, contextHandler.getContextPath()});
            LOGGER.info("(To stop server hit CTRL-C)");
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            throw new JBakeException(SystemExit.SERVER_ERROR, "unable to start the server", e);
        }
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    @Override
    public void close() throws IOException {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOGGER.error("unable to stop server");
            }
        }
    }
}

