/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import java.util.LinkedList;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.Renderer;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class DocumentsRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, JBakeConfiguration config) throws RenderingException {
        int renderedCount = 0;
        LinkedList<String> errors = new LinkedList<String>();
        DocumentList<DocumentModel> documentList = db.getUnrenderedContent();
        for (DocumentModel document : documentList) {
            try {
                DocumentList<DocumentModel> typedDocList = db.getAllContent(document.getType());
                this.setPrevDoc(typedDocList, document);
                this.setNextDoc(typedDocList, document);
                renderer.render(document);
                db.markContentAsRendered(document);
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render documents. Cause(s):");
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            throw new RenderingException(sb.toString());
        }
        return renderedCount;
    }

    private void setNextDoc(DocumentList<DocumentModel> typedList, DocumentModel doc) {
        int typedListIndex = typedList.indexOf(doc);
        if (((DocumentModel)typedList.getFirst()).equals(doc)) {
            doc.setNextContent(null);
        } else {
            boolean found = false;
            while (!found) {
                try {
                    DocumentModel nextDoc = (DocumentModel)typedList.get(typedListIndex - 1);
                    if (this.isPublished(nextDoc)) {
                        doc.setNextContent(this.getContentForNav(nextDoc));
                        found = true;
                        continue;
                    }
                    --typedListIndex;
                }
                catch (IndexOutOfBoundsException ex) {
                    found = true;
                }
            }
        }
    }

    private void setPrevDoc(DocumentList<DocumentModel> typedList, DocumentModel doc) {
        int typedListIndex = typedList.indexOf(doc);
        if (((DocumentModel)typedList.getLast()).equals(doc)) {
            doc.setPreviousContent(null);
        } else {
            boolean found = false;
            while (!found) {
                try {
                    DocumentModel prevDoc = (DocumentModel)typedList.get(typedListIndex + 1);
                    if (this.isPublished(prevDoc)) {
                        doc.setPreviousContent(this.getContentForNav(prevDoc));
                        found = true;
                        continue;
                    }
                    ++typedListIndex;
                }
                catch (IndexOutOfBoundsException ex) {
                    found = true;
                }
            }
        }
    }

    private boolean isPublished(DocumentModel document) {
        return "published".equals(document.getStatus());
    }

    private DocumentModel getContentForNav(DocumentModel document) {
        DocumentModel navDocument = new DocumentModel();
        navDocument.setNoExtensionUri(document.getNoExtensionUri());
        navDocument.setUri(document.getUri());
        navDocument.setTitle(document.getTitle());
        return navDocument;
    }

    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        return this.render(renderer, db, null);
    }
}

