/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.escaper.EscaperExtension;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.jbake.template.model.TemplateModel;

public class PebbleTemplateEngine
extends AbstractTemplateEngine {
    private PebbleEngine engine;

    public PebbleTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.initializeTemplateEngine();
    }

    private void initializeTemplateEngine() {
        FileLoader loader = new FileLoader();
        loader.setPrefix(this.config.getTemplateFolder().getAbsolutePath());
        EscaperExtension escaper = new EscaperExtension();
        escaper.setAutoEscaping(false);
        this.engine = new PebbleEngine.Builder().loader((Loader)loader).extension(new Extension[]{escaper}).build();
    }

    @Override
    public void renderDocument(TemplateModel model, String templateName, Writer writer) throws RenderingException {
        try {
            PebbleTemplate template = this.engine.getTemplate(templateName);
            template.evaluate(writer, (Map)this.wrap(model));
        }
        catch (PebbleException | IOException e) {
            throw new RenderingException(e);
        }
    }

    private TemplateModel wrap(TemplateModel model) {
        return new TemplateModel(model){
            private static final long serialVersionUID = -5489285491728950547L;

            @Override
            public Object get(Object property) {
                try {
                    return AbstractTemplateEngine.extractors.extractAndTransform(PebbleTemplateEngine.this.db, (String)property, this, new TemplateEngineAdapter.NoopAdapter());
                }
                catch (NoModelExtractorException e) {
                    return super.get(property);
                }
            }
        };
    }
}

