/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.PegdownExtensions;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Extension;
import java.lang.reflect.Field;
import java.util.List;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownEngine
extends MarkupEngine {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownEngine.class);

    @Override
    public void processBody(ParserContext context) {
        List<String> mdExts = context.getConfig().getMarkdownExtensions();
        int extensions = 0;
        for (String ext : mdExts) {
            if (ext.startsWith("-")) {
                ext = ext.substring(1);
                extensions = this.removeExtension(extensions, this.extensionFor(ext));
                continue;
            }
            if (ext.startsWith("+")) {
                ext = ext.substring(1);
            }
            extensions = this.addExtension(extensions, this.extensionFor(ext));
        }
        DataHolder options = PegdownOptionsAdapter.flexmarkOptions((int)extensions, (Extension[])new Extension[0]);
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parse(context.getBody());
        context.setBody(renderer.render((Node)document));
    }

    private int extensionFor(String name) {
        int extension = 0;
        try {
            Field extField = PegdownExtensions.class.getDeclaredField(name);
            extension = extField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.debug("Undeclared extension field '{}', fallback to NONE", (Object)name);
        }
        return extension;
    }

    private int addExtension(int previousExtensions, int additionalExtension) {
        return previousExtensions | additionalExtension;
    }

    private int removeExtension(int previousExtensions, int unwantedExtension) {
        return previousExtensions & ~unwantedExtension;
    }
}

