/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.lang3.LocaleUtils;
import org.jbake.app.Asset;
import org.jbake.app.ContentStore;
import org.jbake.app.Crawler;
import org.jbake.app.Renderer;
import org.jbake.app.Utensils;
import org.jbake.app.UtensilsFactory;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.app.configuration.JBakeConfigurationInspector;
import org.jbake.model.DocumentTypes;
import org.jbake.render.RenderingTool;
import org.jbake.template.ModelExtractors;
import org.jbake.template.ModelExtractorsDocumentTypeListener;
import org.jbake.template.RenderingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oven {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oven.class);
    private final Utensils utensils;
    private final List<Throwable> errors = new LinkedList<Throwable>();
    private int renderedCount = 0;

    @Deprecated
    public Oven(File source, File destination, boolean isClearCache) throws Exception {
        this(new JBakeConfigurationFactory().createDefaultJbakeConfiguration(source, destination, isClearCache));
    }

    @Deprecated
    public Oven(File source, File destination, CompositeConfiguration config, boolean isClearCache) throws Exception {
        this(new JBakeConfigurationFactory().createDefaultJbakeConfiguration(source, destination, config, isClearCache));
    }

    public Oven(JBakeConfiguration config) {
        this.utensils = UtensilsFactory.createDefaultUtensils(config);
    }

    public Oven(Utensils utensils) {
        this.checkConfiguration(utensils.getConfiguration());
        this.utensils = utensils;
    }

    @Deprecated
    public CompositeConfiguration getConfig() {
        return ((DefaultJBakeConfiguration)this.utensils.getConfiguration()).getCompositeConfiguration();
    }

    @Deprecated
    public void setConfig(CompositeConfiguration config) {
        ((DefaultJBakeConfiguration)this.utensils.getConfiguration()).setCompositeConfiguration(config);
    }

    @Deprecated
    public void setupPaths() {
    }

    private void checkConfiguration(JBakeConfiguration configuration) {
        JBakeConfigurationInspector inspector = new JBakeConfigurationInspector(configuration);
        inspector.inspect();
    }

    private void setLocale() {
        String localeString = this.getUtensils().getConfiguration().getJvmLocale();
        Locale locale = localeString != null ? LocaleUtils.toLocale((String)localeString) : Locale.getDefault();
        Locale.setDefault(locale);
    }

    public void bake(File fileToBake) {
        Asset asset = this.utensils.getAsset();
        if (asset.isAssetFile(fileToBake)) {
            LOGGER.info("Baking a change to an asset [" + fileToBake.getPath() + "]");
            asset.copySingleFile(fileToBake);
        } else {
            LOGGER.info("Playing it safe and running a full bake...");
            this.bake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bake() {
        ContentStore contentStore = this.utensils.getContentStore();
        JBakeConfiguration config = this.utensils.getConfiguration();
        Crawler crawler = this.utensils.getCrawler();
        Asset asset = this.utensils.getAsset();
        this.setLocale();
        try {
            long start = new Date().getTime();
            LOGGER.info("Baking has started...");
            contentStore.startup();
            this.updateDocTypesFromConfiguration();
            contentStore.updateSchema();
            contentStore.updateAndClearCacheIfNeeded(config.getClearCache(), config.getTemplateFolder());
            crawler.crawl();
            crawler.crawlDataFiles();
            this.renderContent();
            asset.copy();
            asset.copyAssetsFromContent(config.getContentFolder());
            this.errors.addAll(asset.getErrors());
            LOGGER.info("Baking finished!");
            long end = new Date().getTime();
            LOGGER.info("Baked {} items in {}ms", (Object)this.renderedCount, (Object)(end - start));
            if (!this.errors.isEmpty()) {
                LOGGER.error("Failed to bake {} item(s)!", (Object)this.errors.size());
            }
        }
        finally {
            contentStore.close();
            contentStore.shutdown();
        }
    }

    private void updateDocTypesFromConfiguration() {
        this.resetDocumentTypesAndExtractors();
        JBakeConfiguration config = this.utensils.getConfiguration();
        ModelExtractorsDocumentTypeListener listener = new ModelExtractorsDocumentTypeListener();
        DocumentTypes.addListener(listener);
        for (String docType : config.getDocumentTypes()) {
            DocumentTypes.addDocumentType(docType);
        }
        DocumentTypes.addDocumentType(config.getDataFileDocType());
    }

    private void resetDocumentTypesAndExtractors() {
        DocumentTypes.resetDocumentTypes();
        ModelExtractors.getInstance().reset();
    }

    private void renderContent() {
        JBakeConfiguration config = this.utensils.getConfiguration();
        Renderer renderer = this.utensils.getRenderer();
        ContentStore contentStore = this.utensils.getContentStore();
        for (RenderingTool tool : ServiceLoader.load(RenderingTool.class)) {
            try {
                this.renderedCount += tool.render(renderer, contentStore, config);
            }
            catch (RenderingException e) {
                this.errors.add(e);
            }
        }
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    public Utensils getUtensils() {
        return this.utensils;
    }
}

