/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(description={"JBake is a Java based, open source, static site/blog generator for developers & designers"}, name="jbake", usageHelpAutoWidth=true)
public class LaunchOptions {
    @CommandLine.Parameters(index="0", description={"source folder of site content (with templates and assets), if not supplied will default to current directory"}, arity="0..1")
    private String source;
    @CommandLine.Parameters(index="1", description={"destination folder for output, if not supplied will default to a folder called \"output\" in the current directory"}, arity="0..1")
    private String destination;
    @CommandLine.Option(names={"-b", "--bake"}, description={"performs a bake"})
    private boolean bake;
    @CommandLine.ArgGroup(exclusive=false, heading="%n%nJBake initialization%n%n")
    private InitOptions initGroup;
    @CommandLine.Option(names={"-s", "--server"}, description={"runs HTTP server to serve out baked site, if no <value> is supplied will default to a folder called \"output\" in the current directory"})
    private boolean runServer;
    @CommandLine.Option(names={"-h", "--help"}, description={"prints this message"}, usageHelp=true)
    private boolean helpRequested;
    @CommandLine.Option(names={"--reset"}, description={"clears the local cache, enforcing rendering from scratch"})
    private boolean clearCache;
    @CommandLine.Option(names={"-c", "--config"}, description={"use specified file for configuration (defaults to jbake.properties in the source folder if not supplied)"})
    private String config;
    @CommandLine.Option(names={"--prop-encoding"}, description={"use given encoding to load properties file. default: utf-8"})
    private String propertiesEncoding = "utf-8";
    @CommandLine.Option(names={"-ls", "--list-settings"}, description={"list configuration settings"})
    private boolean listConfig;

    public String getTemplate() {
        return this.initGroup.template;
    }

    public File getSource() {
        if (this.source != null) {
            return new File(this.source);
        }
        return new File(System.getProperty("user.dir"));
    }

    public String getSourceValue() {
        return this.source;
    }

    public File getDestination() {
        if (this.destination != null) {
            return new File(this.destination);
        }
        return new File(this.getSource(), "output");
    }

    public String getDestinationValue() {
        return this.destination;
    }

    public File getConfig() {
        if (this.config != null) {
            return new File(this.config);
        }
        return new File(this.getSource(), "jbake.properties");
    }

    public String getConfigValue() {
        return this.config;
    }

    public boolean isHelpNeeded() {
        return this.helpRequested || !this.isListConfig() && !this.isBake() && !this.isRunServer() && !this.isInit() && this.source == null && this.destination == null;
    }

    public boolean isRunServer() {
        return this.runServer;
    }

    public boolean isInit() {
        return this.initGroup != null && this.initGroup.init;
    }

    public boolean isClearCache() {
        return this.clearCache;
    }

    public boolean isBake() {
        return this.bake || this.source != null && this.destination != null;
    }

    public boolean isListConfig() {
        return this.listConfig;
    }

    public String getPropertiesEncoding() {
        return this.propertiesEncoding;
    }

    static class InitOptions {
        @CommandLine.Option(names={"-i", "--init"}, paramLabel="<target>", description={"initialises required folder structure with default templates (defaults to current directory if <source> is not supplied)"}, required=true)
        private boolean init;
        @CommandLine.Option(names={"-t", "--template"}, defaultValue="freemarker", fallbackValue="freemarker", description={"use specified template engine for default templates (uses Freemarker if <template> is not supplied) "}, arity="0..1")
        private String template;

        InitOptions() {
        }
    }
}

