/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidoctorEngine
extends MarkupEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidoctorEngine.class);
    public static final String JBAKE_PREFIX = "jbake-";
    public static final String REVDATE_KEY = "revdate";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Asciidoctor engine;
    private static final String OPT_GEM_PATH = "gemPath";
    private static final String OPT_REQUIRES = "requires";

    public AsciidoctorEngine() {
        Class<Asciidoctor> engineClass = Asciidoctor.class;
        assert (engineClass != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asciidoctor getEngine(Options options) {
        block9: {
            try {
                this.lock.readLock().lock();
                if (this.engine != null) break block9;
                this.lock.readLock().unlock();
                try {
                    this.lock.writeLock().lock();
                    if (this.engine == null) {
                        String[] requires;
                        LOGGER.info("Initializing Asciidoctor engine...");
                        this.engine = options.map().containsKey(OPT_GEM_PATH) ? AsciidoctorJRuby.Factory.create((String)String.valueOf(options.map().get(OPT_GEM_PATH))) : Asciidoctor.Factory.create();
                        if (options.map().containsKey(OPT_REQUIRES) && (requires = String.valueOf(options.map().get(OPT_REQUIRES)).split(",")).length != 0) {
                            for (String require : requires) {
                                this.engine.requireLibrary(new String[]{require});
                            }
                        }
                        LOGGER.info("Asciidoctor engine initialized.");
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return this.engine;
    }

    @Override
    public void processHeader(ParserContext context) {
        Options options = this.getAsciiDocOptionsAndAttributes(context);
        Asciidoctor asciidoctor = this.getEngine(options);
        DocumentHeader header = asciidoctor.readDocumentHeader(context.getFile());
        DocumentModel documentModel = context.getDocumentModel();
        if (header.getDocumentTitle() != null) {
            documentModel.setTitle(header.getDocumentTitle().getCombined());
        }
        Map attributes = header.getAttributes();
        for (Map.Entry attribute : attributes.entrySet()) {
            String key = (String)attribute.getKey();
            Object value = attribute.getValue();
            if (this.hasJBakePrefix(key)) {
                String pKey = key.substring(6);
                if (this.canCastToString(value)) {
                    this.storeHeaderValue(pKey, (String)value, documentModel);
                } else {
                    documentModel.put(pKey, value);
                }
            }
            if (this.hasRevdate(key) && this.canCastToString(value)) {
                String dateFormat = context.getConfig().getDateFormat();
                SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                try {
                    Date date = df.parse((String)value);
                    context.setDate(date);
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse revdate. Expected {}", (Object)dateFormat, (Object)e);
                }
            }
            if (key.equals("jbake-tags")) {
                if (this.canCastToString(value)) {
                    context.setTags(((String)value).split(","));
                    continue;
                }
                LOGGER.error("Wrong value of 'jbake-tags'. Expected a String got '{}'", (Object)this.getValueClassName(value));
                continue;
            }
            documentModel.put(key, attributes.get(key));
        }
    }

    private boolean canCastToString(Object value) {
        return value instanceof String;
    }

    private String getValueClassName(Object value) {
        return value == null ? "null" : value.getClass().getCanonicalName();
    }

    private boolean hasRevdate(String key) {
        return key.equals(REVDATE_KEY);
    }

    private boolean hasJBakePrefix(String key) {
        return key.startsWith(JBAKE_PREFIX);
    }

    @Override
    public void processBody(ParserContext context) {
        StringBuilder body = new StringBuilder(context.getBody().length());
        if (!context.hasHeader()) {
            for (String line : context.getFileLines()) {
                body.append(line).append("\n");
            }
            context.setBody(body.toString());
        }
        this.processAsciiDoc(context);
    }

    private void processAsciiDoc(ParserContext context) {
        Options options = this.getAsciiDocOptionsAndAttributes(context);
        Asciidoctor asciidoctor = this.getEngine(options);
        context.setBody(asciidoctor.convert(context.getBody(), options));
    }

    private Options getAsciiDocOptionsAndAttributes(ParserContext context) {
        JBakeConfiguration config = context.getConfig();
        List<String> asciidoctorAttributes = config.getAsciidoctorAttributes();
        AttributesBuilder attributes = AttributesBuilder.attributes((String[])asciidoctorAttributes.toArray(new String[0]));
        if (config.getExportAsciidoctorAttributes()) {
            String prefix = config.getAttributesExportPrefixForAsciidoctor();
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                if (key.startsWith("asciidoctor")) continue;
                attributes.attribute(prefix + key.replace(".", "_"), config.get(key));
            }
        }
        List<String> optionsSubset = config.getAsciidoctorOptionKeys();
        Options options = OptionsBuilder.options().attributes(attributes.get()).get();
        for (String optionKey : optionsSubset) {
            Object optionValue = config.getAsciidoctorOption(optionKey);
            if (optionKey.equals("template_dirs")) {
                List<String> dirs = this.getAsList(optionValue);
                if (dirs.isEmpty()) continue;
                options.setTemplateDirs(new String[]{String.valueOf(dirs)});
                continue;
            }
            options.setOption(optionKey, optionValue);
        }
        options.setBaseDir(context.getFile().getParentFile().getAbsolutePath());
        options.setSafe(SafeMode.UNSAFE);
        return options;
    }

    private List<String> getAsList(Object asciidoctorOption) {
        ArrayList<String> values = new ArrayList<String>();
        if (asciidoctorOption instanceof List) {
            values.addAll((List)asciidoctorOption);
        } else if (asciidoctorOption instanceof String) {
            values.add(String.valueOf(asciidoctorOption));
        }
        return values;
    }
}

