/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.jbake.template.model.TemplateModel;
import org.jbake.util.DataFileUtil;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private Configuration templateCfg;

    @Deprecated
    public FreemarkerTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((org.apache.commons.configuration2.Configuration)config, db, destination, templatesPath);
        this.createTemplateConfiguration();
    }

    public FreemarkerTemplateEngine(JBakeConfiguration config, ContentStore db) {
        super(config, db);
        this.createTemplateConfiguration();
    }

    private void createTemplateConfiguration() {
        this.templateCfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.templateCfg.setDefaultEncoding(this.config.getRenderEncoding());
        this.templateCfg.setOutputEncoding(this.config.getOutputEncoding());
        if (this.config.getFreemarkerTimeZone() != null) {
            this.templateCfg.setTimeZone(this.config.getFreemarkerTimeZone());
            this.templateCfg.setSQLDateAndTimeTimeZone(this.config.getFreemarkerTimeZone());
        }
        try {
            this.templateCfg.setDirectoryForTemplateLoading(this.config.getTemplateFolder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renderDocument(TemplateModel model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.templateCfg.getTemplate(templateName);
            template.process((Object)new LazyLoadingModel(this.templateCfg.getObjectWrapper(), model, this.db, this.config), writer);
        }
        catch (TemplateException | IOException e) {
            throw new RenderingException(e);
        }
    }

    public static class LazyLoadingModel
    implements TemplateHashModel {
        private final ObjectWrapper wrapper;
        private final SimpleHash eagerModel;
        private final ContentStore db;
        private final JBakeConfiguration config;

        public LazyLoadingModel(ObjectWrapper wrapper, TemplateModel eagerModel, ContentStore db, JBakeConfiguration config) {
            this.eagerModel = new SimpleHash((Map)eagerModel, wrapper);
            this.db = db;
            this.wrapper = wrapper;
            this.config = config;
        }

        public freemarker.template.TemplateModel get(String key) throws TemplateModelException {
            try {
                if (key.equals("db")) {
                    BeansWrapperBuilder bwb = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
                    BeansWrapper bw = bwb.build();
                    return bw.wrap((Object)this.db);
                }
                if (key.equals("data")) {
                    BeansWrapperBuilder bwb = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
                    BeansWrapper bw = bwb.build();
                    return bw.wrap((Object)new DataFileUtil(this.db, this.config.getDataFileDocType()));
                }
                return AbstractTemplateEngine.extractors.extractAndTransform(this.db, key, this.eagerModel.toMap(), new TemplateEngineAdapter<freemarker.template.TemplateModel>(){

                    @Override
                    public freemarker.template.TemplateModel adapt(String key, Object extractedValue) {
                        if (key.equals("alltags")) {
                            return new SimpleCollection((Collection)extractedValue, wrapper);
                        }
                        if (key.equals("published_date")) {
                            return new SimpleDate((Date)extractedValue, 0);
                        }
                        return new SimpleSequence((Collection)extractedValue, wrapper);
                    }
                });
            }
            catch (NoModelExtractorException e) {
                return this.eagerModel.get(key);
            }
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

