/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.util.Objects;

public class Property
implements Comparable<Property> {
    private final String key;
    private final String description;
    private final Group group;

    public Property(String key, String description) {
        this(key, description, Group.DEFAULT);
    }

    public Property(String key, String description, Group group) {
        this.key = key;
        this.description = description;
        this.group = group;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public Group getGroup() {
        return this.group;
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return Objects.equals(this.key, property.key) && Objects.equals(this.description, property.description) && this.group == property.group;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.description, this.group});
    }

    @Override
    public int compareTo(Property other) {
        int result = this.getGroup().compareTo(other.getGroup());
        if (result == 0) {
            result = this.getKey().compareTo(other.getKey());
        }
        return result;
    }

    public static enum Group {
        DEFAULT,
        CUSTOM;

    }
}

