/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import java.util.LinkedList;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.Renderer;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.model.DocumentModel;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class DocumentsRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, JBakeConfiguration config) throws RenderingException {
        int renderedCount = 0;
        LinkedList<String> errors = new LinkedList<String>();
        DocumentList<DocumentModel> documentList = db.getUnrenderedContent();
        for (DocumentModel document : documentList) {
            try {
                DocumentList<DocumentModel> typedDocList = db.getAllContent(document.getType());
                DocumentModel prev = this.getPrevDoc(typedDocList, document);
                DocumentModel next = this.getNextDoc(typedDocList, document);
                document.setPreviousContent(prev);
                document.setNextContent(next);
                renderer.render(document);
                db.markContentAsRendered(document);
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render documents. Cause(s):");
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            throw new RenderingException(sb.toString());
        }
        return renderedCount;
    }

    private DocumentModel getNextDoc(DocumentList<DocumentModel> typedList, DocumentModel doc) {
        int typedListIndex = typedList.indexOf(doc);
        if (((DocumentModel)typedList.getFirst()).equals(doc)) {
            return null;
        }
        try {
            while (true) {
                DocumentModel nextDoc;
                if (this.isPublished(nextDoc = (DocumentModel)typedList.get(typedListIndex - 1))) {
                    return this.getContentForNav(nextDoc);
                }
                --typedListIndex;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private DocumentModel getPrevDoc(DocumentList<DocumentModel> typedList, DocumentModel doc) {
        int typedListIndex = typedList.indexOf(doc);
        if (((DocumentModel)typedList.getLast()).equals(doc)) {
            return null;
        }
        try {
            while (true) {
                DocumentModel prevDoc;
                if (this.isPublished(prevDoc = (DocumentModel)typedList.get(typedListIndex + 1))) {
                    return this.getContentForNav(prevDoc);
                }
                ++typedListIndex;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private boolean isPublished(DocumentModel document) {
        return "published".equals(document.getStatus());
    }

    private DocumentModel getContentForNav(DocumentModel document) {
        DocumentModel navDocument = new DocumentModel();
        navDocument.setNoExtensionUri(document.getNoExtensionUri());
        navDocument.setUri(document.getUri());
        navDocument.setTitle(document.getTitle());
        return navDocument;
    }

    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        return this.render(renderer, db, null);
    }
}

