/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.File;
import java.io.Writer;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngines;
import org.jbake.template.model.TemplateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingTemplateEngine.class);
    private final TemplateEngines renderers;

    @Deprecated
    public DelegatingTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
        this.renderers = new TemplateEngines(this.config, db);
    }

    public DelegatingTemplateEngine(ContentStore db, JBakeConfiguration config) {
        super(config, db);
        this.renderers = new TemplateEngines(config, db);
    }

    @Override
    public void renderDocument(TemplateModel model, String templateName, Writer writer) throws RenderingException {
        String ext;
        AbstractTemplateEngine engine;
        model.setVersion(this.config.getVersion());
        model.setConfig(this.config.asHashMap());
        File templateFolder = this.config.getTemplateFolder();
        File templateFile = new File(templateFolder, templateName);
        String theTemplateName = templateName;
        if (!templateFile.exists()) {
            LOGGER.info("Default template: {} was not found, searching for others...", (Object)templateName);
            String templateNameWithoutExt = templateName.substring(0, templateName.length() - 4);
            for (String extension : this.renderers.getRecognizedExtensions()) {
                templateFile = new File(templateFolder, templateNameWithoutExt + "." + extension);
                if (!templateFile.exists()) continue;
                LOGGER.info("Found alternative template file: {} using this instead", (Object)templateFile.getName());
                theTemplateName = templateFile.getName();
                break;
            }
        }
        if ((engine = this.renderers.getEngine(ext = FileUtil.fileExt(theTemplateName))) != null) {
            engine.renderDocument(model, theTemplateName, writer);
        } else {
            LOGGER.error("Warning - No template engine found for template: {}", (Object)theTemplateName);
        }
    }
}

