/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.app.FileUtil;
import org.jbake.model.DocumentModel;
import org.jbake.model.DocumentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStore {
    private static final String STATEMENT_GET_PUBLISHED_POST_BY_TYPE_AND_TAG = "select * from Documents where status='published' and type='%s' and ? in tags order by date desc";
    private static final String STATEMENT_GET_DOCUMENT_STATUS_BY_DOCTYPE_AND_URI = "select sha1,rendered from Documents where sourceuri=?";
    private static final String STATEMENT_GET_PUBLISHED_COUNT = "select count(*) as count from Documents where status='published' and type='%s'";
    private static final String STATEMENT_MARK_CONTENT_AS_RENDERD = "update Documents set rendered=true where rendered=false and type='%s' and sourceuri='%s' and cached=true";
    private static final String STATEMENT_DELETE_DOCTYPE_BY_SOURCEURI = "delete from Documents where sourceuri=?";
    private static final String STATEMENT_GET_UNDRENDERED_CONTENT = "select * from Documents where rendered=false order by date desc";
    private static final String STATEMENT_GET_SIGNATURE_FOR_TEMPLATES = "select sha1 from Signatures where key='templates'";
    private static final String STATEMENT_GET_TAGS_FROM_PUBLISHED_POSTS = "select tags from Documents where status='published' and type='post'";
    private static final String STATEMENT_GET_ALL_CONTENT_BY_DOCTYPE = "select * from Documents where type='%s' order by date desc";
    private static final String STATEMENT_GET_PUBLISHED_CONTENT_BY_DOCTYPE = "select * from Documents where status='published' and type='%s' order by date desc";
    private static final String STATEMENT_GET_PUBLISHED_POSTS_BY_TAG = "select * from Documents where status='published' and type='post' and ? in tags order by date desc";
    private static final String STATEMENT_GET_TAGS_BY_DOCTYPE = "select tags from Documents where status='published' and type='%s'";
    private static final String STATEMENT_INSERT_TEMPLATES_SIGNATURE = "insert into Signatures(key,sha1) values('templates',?)";
    private static final String STATEMENT_DELETE_ALL = "delete from Documents where type='%s'";
    private static final String STATEMENT_UPDATE_TEMPLATE_SIGNATURE = "update Signatures set sha1=? where key='templates'";
    private static final String STATEMENT_GET_DOCUMENT_COUNT_BY_TYPE = "select count(*) as count from Documents where type='%s'";
    private final Logger logger = LoggerFactory.getLogger(ContentStore.class);
    private final String type;
    private final String name;
    private ODatabaseSession db;
    private long start = -1L;
    private long limit = -1L;
    private OrientDB orient;

    public ContentStore(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public void startup() {
        this.startupIfEnginesAreMissing();
        this.orient = this.type.equalsIgnoreCase(ODatabaseType.PLOCAL.name()) ? new OrientDB(this.type + ":" + this.name, OrientDBConfig.defaultConfig()) : new OrientDB(this.type + ":", OrientDBConfig.defaultConfig());
        this.orient.createIfNotExists(this.name, ODatabaseType.valueOf((String)this.type.toUpperCase()));
        this.db = this.orient.open(this.name, "admin", "admin");
        this.activateOnCurrentThread();
        this.updateSchema();
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void resetPagination() {
        this.start = -1L;
        this.limit = -1L;
    }

    public final void updateSchema() {
        OSchema schema = this.db.getMetadata().getSchema();
        if (!schema.existsClass("Documents")) {
            this.createDocType(schema);
        }
        if (!schema.existsClass("Signatures")) {
            this.createSignatureType(schema);
        }
    }

    public void close() {
        if (this.db != null) {
            this.activateOnCurrentThread();
            this.db.close();
        }
        if (this.orient != null) {
            this.orient.close();
        }
        DBUtil.closeDataStore();
    }

    public void shutdown() {
    }

    private void startupIfEnginesAreMissing() {
        OLogManager.instance().setWarnEnabled(false);
        if (Orient.instance().getEngines().isEmpty()) {
            Orient.instance().startup();
        }
        OLogManager.instance().setWarnEnabled(true);
    }

    public void drop() {
        this.activateOnCurrentThread();
        this.orient.drop(this.name);
    }

    private void activateOnCurrentThread() {
        if (this.db != null) {
            this.db.activateOnCurrentThread();
        } else {
            System.out.println("db is null on activate");
        }
    }

    public long getDocumentCount(String docType) {
        this.activateOnCurrentThread();
        String statement = String.format(STATEMENT_GET_DOCUMENT_COUNT_BY_TYPE, docType);
        return (Long)((DocumentModel)this.query(statement).get(0)).get("count");
    }

    public long getPublishedCount(String docType) {
        String statement = String.format(STATEMENT_GET_PUBLISHED_COUNT, docType);
        return (Long)((DocumentModel)this.query(statement).get(0)).get("count");
    }

    public DocumentList<DocumentModel> getDocumentByUri(String uri) {
        return this.query("select * from Documents where sourceuri=?", uri);
    }

    public DocumentList<DocumentModel> getDocumentStatus(String uri) {
        return this.query(STATEMENT_GET_DOCUMENT_STATUS_BY_DOCTYPE_AND_URI, uri);
    }

    public DocumentList<DocumentModel> getPublishedPosts() {
        return this.getPublishedContent("post");
    }

    public DocumentList<DocumentModel> getPublishedPosts(boolean applyPaging) {
        return this.getPublishedContent("post", applyPaging);
    }

    public DocumentList<DocumentModel> getPublishedPostsByTag(String tag) {
        return this.query(STATEMENT_GET_PUBLISHED_POSTS_BY_TAG, tag);
    }

    public DocumentList<DocumentModel> getPublishedDocumentsByTag(String tag) {
        DocumentList<DocumentModel> documents = new DocumentList<DocumentModel>();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            String statement = String.format(STATEMENT_GET_PUBLISHED_POST_BY_TYPE_AND_TAG, docType);
            DocumentList<DocumentModel> documentsByTag = this.query(statement, tag);
            documents.addAll(documentsByTag);
        }
        return documents;
    }

    public DocumentList<DocumentModel> getPublishedPages() {
        return this.getPublishedContent("page");
    }

    public DocumentList<DocumentModel> getPublishedContent(String docType) {
        return this.getPublishedContent(docType, false);
    }

    private DocumentList<DocumentModel> getPublishedContent(String docType, boolean applyPaging) {
        String query = String.format(STATEMENT_GET_PUBLISHED_CONTENT_BY_DOCTYPE, docType);
        if (applyPaging && this.hasStartAndLimitBoundary()) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    public DocumentList<DocumentModel> getAllContent(String docType) {
        return this.getAllContent(docType, false);
    }

    public DocumentList<DocumentModel> getAllContent(String docType, boolean applyPaging) {
        String query = String.format(STATEMENT_GET_ALL_CONTENT_BY_DOCTYPE, docType);
        if (applyPaging && this.hasStartAndLimitBoundary()) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    private boolean hasStartAndLimitBoundary() {
        return this.start >= 0L && this.limit > -1L;
    }

    private DocumentList<DocumentModel> getAllTagsFromPublishedPosts() {
        return this.query(STATEMENT_GET_TAGS_FROM_PUBLISHED_POSTS);
    }

    private DocumentList<DocumentModel> getSignaturesForTemplates() {
        return this.query(STATEMENT_GET_SIGNATURE_FOR_TEMPLATES);
    }

    public DocumentList<DocumentModel> getUnrenderedContent() {
        return this.query(STATEMENT_GET_UNDRENDERED_CONTENT);
    }

    public void deleteContent(String uri) {
        this.executeCommand(STATEMENT_DELETE_DOCTYPE_BY_SOURCEURI, uri);
    }

    public void markContentAsRendered(DocumentModel document) {
        String statement = String.format(STATEMENT_MARK_CONTENT_AS_RENDERD, document.getType(), document.getSourceuri());
        this.executeCommand(statement, new Object[0]);
    }

    private void updateSignatures(String currentTemplatesSignature) {
        this.executeCommand(STATEMENT_UPDATE_TEMPLATE_SIGNATURE, currentTemplatesSignature);
    }

    public void deleteAllByDocType(String docType) {
        String statement = String.format(STATEMENT_DELETE_ALL, docType);
        this.executeCommand(statement, new Object[0]);
    }

    private void insertTemplatesSignature(String currentTemplatesSignature) {
        this.executeCommand(STATEMENT_INSERT_TEMPLATES_SIGNATURE, currentTemplatesSignature);
    }

    private DocumentList<DocumentModel> query(String sql) {
        this.activateOnCurrentThread();
        OResultSet results = this.db.query(sql, new Object[0]);
        return DocumentList.wrap(results);
    }

    private DocumentList<DocumentModel> query(String sql, Object ... args) {
        this.activateOnCurrentThread();
        OResultSet results = this.db.command(sql, args);
        return DocumentList.wrap(results);
    }

    private void executeCommand(String query, Object ... args) {
        this.activateOnCurrentThread();
        this.db.command(query, args);
    }

    public Set<String> getTags() {
        DocumentList<DocumentModel> docs = this.getAllTagsFromPublishedPosts();
        HashSet<String> result = new HashSet<String>();
        for (DocumentModel document : docs) {
            String[] tags = document.getTags();
            Collections.addAll(result, tags);
        }
        return result;
    }

    public Set<String> getAllTags() {
        HashSet<String> result = new HashSet<String>();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            String statement = String.format(STATEMENT_GET_TAGS_BY_DOCTYPE, docType);
            DocumentList<DocumentModel> docs = this.query(statement);
            for (DocumentModel document : docs) {
                String[] tags = document.getTags();
                Collections.addAll(result, tags);
            }
        }
        return result;
    }

    private void createDocType(OSchema schema) {
        this.logger.debug("Create document class");
        OClass page = schema.createClass("Documents");
        page.createProperty("sha1", OType.STRING).setNotNull(true);
        page.createIndex("Documentssha1Index", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"sha1"});
        page.createProperty("sourceuri", OType.STRING).setNotNull(true);
        page.createIndex("DocumentssourceUriIndex", OClass.INDEX_TYPE.UNIQUE, new String[]{"sourceuri"});
        page.createProperty("cached", OType.BOOLEAN).setNotNull(true);
        page.createIndex("DocumentscachedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"cached"});
        page.createProperty("rendered", OType.BOOLEAN).setNotNull(true);
        page.createIndex("DocumentsrenderedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"rendered"});
        page.createProperty("status", OType.STRING).setNotNull(true);
        page.createIndex("DocumentsstatusIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"status"});
        page.createProperty("type", OType.STRING).setNotNull(true);
        page.createIndex("DocumentstypeIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"type"});
    }

    private void createSignatureType(OSchema schema) {
        OClass signatures = schema.createClass("Signatures");
        signatures.createProperty("sha1", OType.STRING).setNotNull(true);
        signatures.createIndex("sha1Idx", OClass.INDEX_TYPE.UNIQUE, new String[]{"sha1"});
    }

    public void updateAndClearCacheIfNeeded(boolean needed, File templateFolder) {
        boolean clearCache = needed;
        if (!needed) {
            clearCache = this.updateTemplateSignatureIfChanged(templateFolder);
        }
        if (clearCache) {
            this.deleteAllDocumentTypes();
            this.updateSchema();
        }
    }

    private boolean updateTemplateSignatureIfChanged(File templateFolder) {
        String currentTemplatesSignature;
        boolean templateSignatureChanged = false;
        DocumentList<DocumentModel> docs = this.getSignaturesForTemplates();
        try {
            currentTemplatesSignature = FileUtil.sha1(templateFolder);
        }
        catch (Exception e) {
            currentTemplatesSignature = "";
        }
        if (!docs.isEmpty()) {
            String sha1 = ((DocumentModel)docs.get(0)).getSha1();
            if (!sha1.equals(currentTemplatesSignature)) {
                this.updateSignatures(currentTemplatesSignature);
                templateSignatureChanged = true;
            }
        } else {
            this.insertTemplatesSignature(currentTemplatesSignature);
            templateSignatureChanged = true;
        }
        return templateSignatureChanged;
    }

    private void deleteAllDocumentTypes() {
        for (String docType : DocumentTypes.getDocumentTypes()) {
            try {
                this.deleteAllByDocType(docType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isActive() {
        return this.db.isActiveOnCurrentThread();
    }

    public void addDocument(DocumentModel document) {
        OElement element = this.db.newElement("Documents");
        document.forEach((k, v) -> element.setProperty(k, v, new OType[]{OType.ANY}));
        element.save();
    }

    protected abstract class Schema {
        static final String DOCUMENTS = "Documents";
        static final String SIGNATURES = "Signatures";

        protected Schema() {
        }
    }
}

