/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.parser.Engines;

public class FileUtil {
    public static final String URI_SEPARATOR_CHAR = "/";

    public static FileFilter getFileFilter(final JBakeConfiguration config) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden() && pathname.isFile() && Engines.getRecognizedExtensions().contains(FileUtil.fileExt(pathname)) || FileUtil.directoryOnlyIfNotIgnored(pathname, config);
            }
        };
    }

    @Deprecated
    public static FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden() && pathname.isFile() && Engines.getRecognizedExtensions().contains(FileUtil.fileExt(pathname)) || FileUtil.directoryOnlyIfNotIgnored(pathname);
            }
        };
    }

    public static FileFilter getDataFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return "yaml".equalsIgnoreCase(FileUtil.fileExt(pathname)) || "yml".equalsIgnoreCase(FileUtil.fileExt(pathname));
            }
        };
    }

    public static FileFilter getNotContentFileFilter(final JBakeConfiguration config) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden() && pathname.isFile() && !Engines.getRecognizedExtensions().contains(FileUtil.fileExt(pathname)) || FileUtil.directoryOnlyIfNotIgnored(pathname, config);
            }
        };
    }

    @Deprecated
    public static FileFilter getNotContentFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden() && pathname.isFile() && !Engines.getRecognizedExtensions().contains(FileUtil.fileExt(pathname)) || FileUtil.directoryOnlyIfNotIgnored(pathname);
            }
        };
    }

    public static boolean directoryOnlyIfNotIgnored(File file, final JBakeConfiguration config) {
        boolean accept = false;
        FilenameFilter ignoreFile = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(config.getIgnoreFileName());
            }
        };
        accept = file.isDirectory() && file.listFiles(ignoreFile).length == 0;
        return accept;
    }

    @Deprecated
    public static boolean directoryOnlyIfNotIgnored(File file) {
        boolean accept = false;
        FilenameFilter ignoreFile = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(".jbakeignore");
            }
        };
        accept = file.isDirectory() && file.listFiles(ignoreFile).length == 0;
        return accept;
    }

    public static boolean isExistingFolder(File f) {
        return null != f && f.exists() && f.isDirectory();
    }

    public static File getRunningLocation() throws Exception {
        String codePath = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(codePath, "UTF-8");
        File codeFile = new File(decodedPath);
        if (!codeFile.exists()) {
            throw new Exception("Cannot locate running location of JBake!");
        }
        File codeFolder = codeFile.getParentFile().getParentFile();
        if (!codeFolder.exists()) {
            throw new Exception("Cannot locate running location of JBake!");
        }
        return codeFolder;
    }

    public static String fileExt(File src) {
        String name = src.getName();
        return FileUtil.fileExt(name);
    }

    public static String fileExt(String name) {
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            return name.substring(idx + 1);
        }
        return "";
    }

    public static String sha1(File sourceFile) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("SHA-1");
        FileUtil.updateDigest(complete, sourceFile, buffer);
        byte[] bytes = complete.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static void updateDigest(MessageDigest digest, File sourceFile, byte[] buffer) throws IOException {
        File[] files;
        if (sourceFile.isFile()) {
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                int numRead;
                do {
                    if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                    digest.update(buffer, 0, numRead);
                } while (numRead != -1);
            }
        } else if (sourceFile.isDirectory() && (files = sourceFile.listFiles()) != null) {
            for (File file : files) {
                FileUtil.updateDigest(digest, file, buffer);
            }
        }
    }

    public static String asPath(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.asPath(file.getPath());
    }

    public static String asPath(String path) {
        if (path == null) {
            return null;
        }
        if (!File.separator.equals(URI_SEPARATOR_CHAR)) {
            return path.replace(File.separator, URI_SEPARATOR_CHAR);
        }
        return path;
    }

    public static String getPathToRoot(JBakeConfiguration config, File rootPath, File sourceFile) {
        Path r = Paths.get(rootPath.toURI());
        Path s = Paths.get(sourceFile.getParentFile().toURI());
        Path relativePath = s.relativize(r);
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.asPath(relativePath.toString()));
        if (config.getUriWithoutExtension()) {
            sb.append("/..");
        }
        if (sb.length() > 0) {
            sb.append(URI_SEPARATOR_CHAR);
        }
        return sb.toString();
    }

    public static String getUriPathToDestinationRoot(JBakeConfiguration config, File sourceFile) {
        return FileUtil.getPathToRoot(config, config.getDestinationFolder(), sourceFile);
    }

    public static String getUriPathToContentRoot(JBakeConfiguration config, File sourceFile) {
        return FileUtil.getPathToRoot(config, config.getContentFolder(), sourceFile);
    }

    public static boolean isFileInDirectory(File file, File directory) throws IOException {
        return file.exists() && !file.isHidden() && directory.isDirectory() && file.getCanonicalPath().startsWith(directory.getCanonicalPath());
    }
}

