/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.Renderer;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class IndexRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, JBakeConfiguration config) throws RenderingException {
        if (config.getRenderIndex()) {
            try {
                String fileName = config.getIndexFileName();
                if (config.getPaginateIndex()) {
                    renderer.renderIndexPaging(fileName);
                } else {
                    renderer.renderIndex(fileName);
                }
                return 1;
            }
            catch (Exception e) {
                throw new RenderingException(e);
            }
        }
        return 0;
    }

    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        DefaultJBakeConfiguration configuration = new JBakeConfigurationFactory().createDefaultJbakeConfiguration(templatesPath.getParentFile(), config);
        return this.render(renderer, db, configuration);
    }
}

