/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.common;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanMBean;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.common.ClassloadingUtility;
import com.arjuna.ats.internal.arjuna.utils.AndroidProcessId;
import com.arjuna.common.internal.util.propertyservice.FullPropertyName;
import com.arjuna.common.internal.util.propertyservice.PropertyPrefix;
import com.arjuna.common.util.ConfigurationInfo;
import java.io.File;

@PropertyPrefix(prefix="com.arjuna.ats.arjuna.")
public class CoreEnvironmentBean
implements CoreEnvironmentBeanMBean {
    public static final int NODE_NAME_SIZE = 64;
    @FullPropertyName(name="com.arjuna.ats.arjuna.common.varDir")
    private volatile String varDir = System.getProperty("user.dir") + File.separator + "var" + File.separator + "tmp";
    @FullPropertyName(name="com.arjuna.ats.arjuna.nodeIdentifier")
    private volatile String nodeIdentifier = null;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.utils.SocketProcessIdPort")
    private volatile int socketProcessIdPort = 0;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.utils.SocketProcessIdMaxPorts")
    private volatile int socketProcessIdMaxPorts = 1;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.utils.processImplementation")
    private volatile String processImplementationClassName = Utility.getDefaultProcessId();
    private volatile Process processImplementation = null;
    @FullPropertyName(name="com.arjuna.ats.internal.arjuna.utils.pid")
    private volatile int pid = -1;
    private volatile boolean allowMultipleLastResources = false;
    private volatile boolean disableMultipleLastResourcesWarning = false;
    @FullPropertyName(name="timeout.factor")
    private volatile int timeoutFactor = 1;

    @Override
    public String getVarDir() {
        return this.varDir;
    }

    public void setVarDir(String varDir) {
        this.varDir = varDir;
    }

    @Override
    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) throws CoreEnvironmentBeanException {
        if (nodeIdentifier == null) {
            tsLogger.i18NLogger.fatal_nodename_null();
            throw new CoreEnvironmentBeanException(tsLogger.i18NLogger.get_fatal_nodename_null());
        }
        if (nodeIdentifier.getBytes().length > 64) {
            tsLogger.i18NLogger.fatal_nodename_too_long(nodeIdentifier);
            throw new CoreEnvironmentBeanException(tsLogger.i18NLogger.get_fatal_nodename_too_long(nodeIdentifier));
        }
        this.nodeIdentifier = nodeIdentifier;
    }

    @Override
    public int getSocketProcessIdPort() {
        return this.socketProcessIdPort;
    }

    public void setSocketProcessIdPort(int socketProcessIdPort) {
        Utility.validatePortRange(socketProcessIdPort);
        this.socketProcessIdPort = socketProcessIdPort;
    }

    public int getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public void setTimeoutFactor(int timeoutFactor) {
        this.timeoutFactor = timeoutFactor;
    }

    @Override
    public int getSocketProcessIdMaxPorts() {
        return this.socketProcessIdMaxPorts;
    }

    public void setSocketProcessIdMaxPorts(int socketProcessIdMaxPorts) {
        this.socketProcessIdMaxPorts = socketProcessIdMaxPorts;
    }

    @Override
    public String getProcessImplementationClassName() {
        return this.processImplementationClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessImplementationClassName(String processImplementationClassName) {
        CoreEnvironmentBean coreEnvironmentBean = this;
        synchronized (coreEnvironmentBean) {
            if (processImplementationClassName == null) {
                this.processImplementation = null;
            } else if (!processImplementationClassName.equals(this.processImplementationClassName)) {
                this.processImplementation = null;
            }
            this.processImplementationClassName = processImplementationClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getProcessImplementation() {
        if (this.processImplementation == null && this.processImplementationClassName != null) {
            CoreEnvironmentBean coreEnvironmentBean = this;
            synchronized (coreEnvironmentBean) {
                if (this.processImplementation == null && this.processImplementationClassName != null) {
                    try {
                        this.processImplementation = ClassloadingUtility.loadAndInstantiateClass(Process.class, this.processImplementationClassName, null);
                    }
                    catch (NoClassDefFoundError ex) {
                        if (Utility.isAndroid()) {
                            return new AndroidProcessId();
                        }
                        throw ex;
                    }
                }
            }
        }
        return this.processImplementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessImplementation(Process instance) {
        CoreEnvironmentBean coreEnvironmentBean = this;
        synchronized (coreEnvironmentBean) {
            Process oldInstance = this.processImplementation;
            this.processImplementation = instance;
            if (instance == null) {
                this.processImplementationClassName = null;
            } else if (instance != oldInstance) {
                String name;
                this.processImplementationClassName = name = ClassloadingUtility.getNameForClass(instance);
            }
        }
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    @Override
    public boolean isAllowMultipleLastResources() {
        return this.allowMultipleLastResources;
    }

    public void setAllowMultipleLastResources(boolean allowMultipleLastResources) {
        this.allowMultipleLastResources = allowMultipleLastResources;
    }

    @Override
    public boolean isDisableMultipleLastResourcesWarning() {
        return this.disableMultipleLastResourcesWarning;
    }

    public void setDisableMultipleLastResourcesWarning(boolean disableMultipleLastResourcesWarning) {
        this.disableMultipleLastResourcesWarning = disableMultipleLastResourcesWarning;
    }

    @Override
    public String getBuildVersion() {
        return ConfigurationInfo.getVersion();
    }

    @Override
    public String getBuildId() {
        return ConfigurationInfo.getBuildId();
    }
}

