/*
 * Decompiled with CFR 0.152.
 */
package org.jberet;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.BatchStatus;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.util.BatchLogger;
import org.jberet.util.ConcurrencyService;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws BatchRuntimeException {
        String jobXml;
        if (args.length == 0) {
            Main.usage(args);
        }
        if ((jobXml = args[0]) == null || jobXml.isEmpty()) {
            Main.usage(args);
        }
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        long timeout = Long.getLong("org.jberet.job.execution.timeout.seconds", 300L);
        try {
            long jobExecutionId = jobOperator.start(jobXml, null);
            JobExecutionImpl jobExecution = (JobExecutionImpl)jobOperator.getJobExecution(jobExecutionId);
            jobExecution.awaitTerminatioin(timeout, TimeUnit.SECONDS);
            if (!jobExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
                throw new BatchRuntimeException(String.format("The job did not complete: %s%n", jobXml));
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                ConcurrencyService.shutdown();
                ConcurrencyService.getExecutorService().awaitTermination(timeout, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {}
        }
    }

    private static void usage(String[] args) {
        BatchLogger.LOGGER.mainUsage(Arrays.asList(args));
    }
}

