/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public class BatchConfig {
    public static final String CONFIG_FILE_NAME = "jberet.properties";
    private volatile Properties configProperties;

    private BatchConfig() {
    }

    public static BatchConfig getInstance() {
        return Holder.instance;
    }

    public synchronized void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfigProperties() {
        Properties result = this.configProperties;
        if (result == null) {
            BatchConfig batchConfig = this;
            synchronized (batchConfig) {
                result = this.configProperties;
                if (result == null) {
                    result = new Properties();
                    InputStream configStream = BatchUtil.getBatchApplicationClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
                    if (configStream != null) {
                        try {
                            result.load(configStream);
                        }
                        catch (IOException e) {
                            throw BatchLogger.LOGGER.failToLoadConfig(e, CONFIG_FILE_NAME);
                        }
                    } else {
                        BatchLogger.LOGGER.useDefaultJBeretConfig(CONFIG_FILE_NAME);
                    }
                    this.configProperties = result;
                }
            }
        }
        return result;
    }

    private static class Holder {
        private static final BatchConfig instance = new BatchConfig();

        private Holder() {
        }
    }
}

