/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.jberet.creation.ArtifactFactory;
import org.jberet.creation.ValueConverter;
import org.jberet.job.Properties;
import org.jberet.metadata.ApplicationMetaData;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public final class SimpleArtifactFactory
implements ArtifactFactory {
    @Override
    public void initialize() throws Exception {
    }

    @Override
    public Class<?> getArtifactClass(String ref, ClassLoader classLoader, Map<?, ?> data) {
        Class<?> cls;
        ApplicationMetaData appData = (ApplicationMetaData)data.get((Object)ArtifactFactory.DataKey.APPLICATION_META_DATA);
        String className = appData.getClassNameForRef(ref);
        try {
            cls = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw BatchLogger.LOGGER.failToCreateArtifact(e, ref);
        }
        return cls;
    }

    @Override
    public Object create(String ref, Class<?> cls, ClassLoader classLoader, Map<?, ?> data) throws Exception {
        if (cls == null) {
            cls = this.getArtifactClass(ref, classLoader, data);
        }
        Object obj = cls.newInstance();
        this.doInjection(obj, cls, classLoader, data);
        this.invokeAnnotatedLifecycleMethod(obj, cls, PostConstruct.class);
        return obj;
    }

    @Override
    public void destroy(Object instance) {
        if (instance != null) {
            try {
                this.invokeAnnotatedLifecycleMethod(instance, instance.getClass(), PreDestroy.class);
            }
            catch (Exception e) {
                BatchLogger.LOGGER.failToDestroyArtifact(e, instance);
            }
        }
    }

    private void doInjection(Object obj, Class<?> cls, ClassLoader classLoader, Map<?, ?> data) throws Exception {
        boolean hasBatchProps;
        Properties batchProps = (Properties)data.get((Object)ArtifactFactory.DataKey.BATCH_PROPERTY);
        boolean bl = hasBatchProps = batchProps != null && batchProps.getProperty().size() > 0;
        while (cls != null && cls != Object.class && !cls.getPackage().getName().startsWith("javax.batch")) {
            for (Field f : cls.getDeclaredFields()) {
                BatchProperty batchPropertyAnn;
                if (f.isSynthetic()) continue;
                Object fieldVal = null;
                if (f.getAnnotation(Inject.class) == null) continue;
                Class<String> fType = f.getType();
                if (fType == JobContext.class) {
                    fieldVal = data.get((Object)ArtifactFactory.DataKey.JOB_CONTEXT);
                } else if (fType == StepContext.class) {
                    fieldVal = data.get((Object)ArtifactFactory.DataKey.STEP_CONTEXT);
                } else if (hasBatchProps && (batchPropertyAnn = f.getAnnotation(BatchProperty.class)) != null) {
                    String sVal;
                    String propName = batchPropertyAnn.name();
                    if (propName.equals("")) {
                        propName = f.getName();
                    }
                    if ((sVal = BatchUtil.getBatchProperty(batchProps, propName)) != null) {
                        fieldVal = sVal.length() == 0 ? null : (!fType.isAssignableFrom(String.class) ? ValueConverter.convertFieldValue(sVal, fType, f, classLoader) : sVal);
                    }
                }
                if (fieldVal == null) continue;
                this.doInjection(obj, f, fieldVal);
            }
            cls = cls.getSuperclass();
        }
    }

    private void invokeAnnotatedLifecycleMethod(Object obj, Class<?> cls, Class<? extends Annotation> annCls) throws Exception {
        ArrayList<Method> lifecycleMethods = new ArrayList<Method>();
        while (cls != null && cls != Object.class && !cls.getPackage().getName().startsWith("javax.batch")) {
            Method[] methods;
            for (Method m : methods = cls.getDeclaredMethods()) {
                if (m.getAnnotation(annCls) == null) continue;
                int modifiers = m.getModifiers();
                String mName = m.getName();
                if (Modifier.isPrivate(modifiers)) {
                    lifecycleMethods.add(m);
                    continue;
                }
                boolean alreadyAdded = false;
                for (Method lm : lifecycleMethods) {
                    if (!lm.getName().equals(mName)) continue;
                    if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
                        alreadyAdded = true;
                        break;
                    }
                    if (!m.getDeclaringClass().getPackage().getName().equals(lm.getDeclaringClass().getPackage().getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                lifecycleMethods.add(m);
            }
            cls = cls.getSuperclass();
        }
        if (annCls == PostConstruct.class) {
            Collections.reverse(lifecycleMethods);
        }
        for (Method m : lifecycleMethods) {
            if (System.getSecurityManager() == null) {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                m.invoke(obj, new Object[0]);
                continue;
            }
            AccessController.doPrivileged(new InvokeMethodPrivilegedExceptionAction(m, obj));
        }
    }

    private void doInjection(Object obj, Field field, Object val) throws Exception {
        if (System.getSecurityManager() == null) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, val);
        } else {
            AccessController.doPrivileged(new SetFieldPrivilegedExceptionAction(field, obj, val));
        }
    }

    private static class InvokeMethodPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Object> {
        private final Method method;
        private final Object obj;

        public InvokeMethodPrivilegedExceptionAction(Method method, Object obj) {
            this.method = method;
            this.obj = obj;
        }

        @Override
        public Object run() throws Exception {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return this.method.invoke(this.obj, new Object[0]);
        }
    }

    private static class SetFieldPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private final Field field;
        private final Object obj;
        private final Object val;

        public SetFieldPrivilegedExceptionAction(Field field, Object obj, Object val) {
            this.field = field;
            this.obj = obj;
            this.val = val;
        }

        @Override
        public Void run() throws Exception {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            this.field.set(this.obj, this.val);
            return null;
        }
    }
}

