/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.batch.operations.JobStartException;
import javax.inject.Named;
import org.jberet.job.BatchArtifactRef;
import org.jberet.job.BatchArtifacts;
import org.jberet.metadata.ArchiveXmlLoader;
import org.jberet.util.BatchLogger;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

public class ApplicationMetaData {
    private AnnotationDB annotationDB;
    private static String[] ignoredPkgs = new String[0];
    private Map<String, String> artifactCatalog = new HashMap<String, String>();
    private BatchArtifacts batchArtifacts;
    private ClassLoader classLoader;

    public ApplicationMetaData(ClassLoader classLoader) throws IOException, JobStartException {
        this.classLoader = classLoader;
        this.annotationDB = new AnnotationDB();
        this.annotationDB.addIgnoredPackages(ignoredPkgs);
        URL[] urls = ClasspathUrlFinder.findClassPaths();
        this.annotationDB.setScanClassAnnotations(true);
        this.annotationDB.setScanMethodAnnotations(false);
        this.annotationDB.setScanFieldAnnotations(false);
        this.annotationDB.setScanParameterAnnotations(false);
        this.annotationDB.scanArchives(urls);
        this.identifyArtifacts();
        this.batchArtifacts = ArchiveXmlLoader.loadBatchXml(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassNameForRef(String ref) {
        String result = this.artifactCatalog.get(ref);
        if (result != null) {
            return result;
        }
        if (this.batchArtifacts != null) {
            for (BatchArtifactRef r : this.batchArtifacts.getRef()) {
                if (!r.getId().equals(ref)) continue;
                return r.getClazz();
            }
        }
        return ref;
    }

    private void identifyArtifacts() {
        Map annotationIndex = this.annotationDB.getAnnotationIndex();
        Set namedClasses = (Set)annotationIndex.get("javax.inject.Named");
        if (namedClasses != null) {
            for (String matchingClass : namedClasses) {
                String refName;
                Class<?> cls;
                try {
                    cls = this.classLoader.loadClass(matchingClass);
                    refName = cls.getAnnotation(Named.class).value();
                }
                catch (ClassNotFoundException e) {
                    BatchLogger.LOGGER.failToIdentifyArtifact(e);
                    continue;
                }
                if (refName.isEmpty()) {
                    char[] chars = cls.getSimpleName().toCharArray();
                    chars[0] = Character.toLowerCase(chars[0]);
                    refName = new String(chars);
                }
                this.artifactCatalog.put(refName, matchingClass);
            }
        }
    }
}

