/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.metadata;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.batch.operations.JobStartException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jberet.job.BatchArtifacts;
import org.jberet.job.Job;
import org.jberet.metadata.JaxbObjectFactory;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;
import org.xml.sax.SAXException;

public class ArchiveXmlLoader {
    public static final String ARCHIVE_JOB_XML_DIR = "META-INF/batch-jobs/";
    public static final String ARCHIVE_BATCH_XML = "META-INF/batch.xml";
    public static final String JOB_XML_SCHEMA = "jobXML_1_0.xsd";
    public static final String BATCH_XML_SCHEMA = "batchXML_1_0.xsd";

    public static BatchArtifacts loadBatchXml(ClassLoader classLoader) throws JobStartException {
        BatchArtifacts batchArtifacts = null;
        InputStream is = classLoader.getResourceAsStream(ARCHIVE_BATCH_XML);
        if (is == null) {
            return null;
        }
        InputStream schemaStream = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BatchArtifacts.class});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            schemaStream = classLoader.getResourceAsStream(BATCH_XML_SCHEMA);
            um.setSchema(ArchiveXmlLoader.getSchema(BATCH_XML_SCHEMA, schemaStream));
            JAXBElement root = um.unmarshal((Source)new StreamSource(is), BatchArtifacts.class);
            batchArtifacts = (BatchArtifacts)root.getValue();
        }
        catch (Exception e) {
            throw BatchLogger.LOGGER.failToParseBindBatchXml(e, ARCHIVE_BATCH_XML);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {}
            }
        }
        return batchArtifacts;
    }

    public static <T> T loadJobXml(String jobName, Class<T> rootType, ClassLoader ... cl) throws JobStartException {
        InputStream is;
        Object jobOrStep = null;
        ClassLoader classLoader = cl.length > 0 ? cl[0] : BatchUtil.getBatchApplicationClassLoader();
        try {
            is = ArchiveXmlLoader.getJobXml(jobName, classLoader);
        }
        catch (IOException e) {
            throw BatchLogger.LOGGER.failToGetJobXml(e, jobName);
        }
        InputStream schemaStream = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Job.class});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            schemaStream = classLoader.getResourceAsStream(JOB_XML_SCHEMA);
            um.setSchema(ArchiveXmlLoader.getSchema(JOB_XML_SCHEMA, schemaStream));
            try {
                um.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new JaxbObjectFactory());
            }
            catch (PropertyException e) {
                um.setProperty("com.sun.xml.internal.bind.ObjectFactory", (Object)new JaxbObjectFactory());
            }
            JAXBElement root = um.unmarshal((Source)new StreamSource(is), rootType);
            jobOrStep = root.getValue();
        }
        catch (Exception e) {
            throw BatchLogger.LOGGER.failToParseBindJobXml(e, jobName);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {}
            }
        }
        return (T)jobOrStep;
    }

    private static Schema getSchema(String schemaLocation, InputStream is) throws URISyntaxException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(new StreamSource(is));
    }

    private static InputStream getJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        String path;
        InputStream is;
        if (!jobXml.endsWith(".xml")) {
            jobXml = jobXml + ".xml";
        }
        if ((is = classLoader.getResourceAsStream(path = ARCHIVE_JOB_XML_DIR + jobXml)) != null) {
            return is;
        }
        File jobFile = null;
        String jobpath = System.getProperty("javax.jobpath");
        if (jobpath != null && !jobpath.isEmpty()) {
            String p;
            String[] jobPathElements;
            String[] arr$ = jobPathElements = jobpath.split(":");
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (jobFile = new File(p = arr$[i$], jobXml)).exists() && jobFile.isFile()); ++i$) {
            }
        }
        if (jobFile == null) {
            jobFile = new File(System.getProperty("user.dir"), jobXml);
        }
        is = new BufferedInputStream(new FileInputStream(jobFile));
        return is;
    }
}

