/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jberet.job.ExceptionClassFilter;
import org.jberet.util.BatchLogger;

public final class ExceptionClassFilterImpl
extends ExceptionClassFilter {
    public boolean matches(Class<? extends Throwable> th) {
        if (this.include == null) {
            return false;
        }
        if (this.exclude == null) {
            return this.matches(th, this.classesFromIncludeExclude(this.include));
        }
        if (!this.matches(th, this.classesFromIncludeExclude(this.include))) {
            return false;
        }
        return !this.matches(th, this.classesFromIncludeExclude(this.exclude));
    }

    private List<String> classesFromIncludeExclude(List<? extends Object> includeExclude) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : includeExclude) {
            String s = object instanceof ExceptionClassFilter.Include ? ((ExceptionClassFilter.Include)object).getClazz().trim() : ((ExceptionClassFilter.Exclude)object).getClazz().trim();
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }

    private boolean matches(Class<? extends Throwable> th, List<String> filterClasses) {
        for (String s : filterClasses) {
            try {
                Class<? extends Throwable> clazz = Class.forName(s, true, th.getClassLoader());
                if (!clazz.isAssignableFrom(th)) continue;
                return true;
            }
            catch (ClassNotFoundException e) {
                BatchLogger.LOGGER.invalidExceptionClassFilter(e, s);
            }
        }
        return false;
    }
}

