/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.jberet.job.Job;
import org.jberet.metadata.ApplicationMetaData;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public abstract class AbstractRepository
implements JobRepository {
    final List<Job> jobs = Collections.synchronizedList(new ArrayList());
    final List<JobInstance> jobInstances = Collections.synchronizedList(new ArrayList());
    final ConcurrentMap<ApplicationAndJobName, ApplicationMetaData> applicationMetaDataMap = new ConcurrentHashMap<ApplicationAndJobName, ApplicationMetaData>();

    abstract void insertJobInstance(JobInstanceImpl var1);

    abstract void insertJobExecution(JobExecutionImpl var1);

    abstract void insertStepExecution(StepExecutionImpl var1, JobExecutionImpl var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJob(Job job) {
        boolean result = false;
        List<Job> list = this.jobs;
        synchronized (list) {
            if (!this.jobs.contains(job)) {
                result = this.jobs.add(job);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(String jobId) {
        List<Job> list = this.jobs;
        synchronized (list) {
            Job toRemove = this.getJob(jobId);
            return toRemove != null && this.jobs.remove(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJob(String jobId) {
        List<Job> list = this.jobs;
        synchronized (list) {
            for (Job j : this.jobs) {
                if (!j.getId().equals(jobId)) continue;
                return j;
            }
        }
        return null;
    }

    @Override
    public Collection<Job> getJobs() {
        return Collections.unmodifiableCollection(this.jobs);
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        ApplicationAndJobName appJobNames = new ApplicationAndJobName(applicationName, job.getId());
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, appJobNames);
        this.insertJobInstance(jobInstance);
        jobInstance.setApplicationMetaData(this.getApplicationMetaData(appJobNames, classLoader));
        this.jobInstances.add(jobInstance);
        return jobInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        List<JobInstance> list = this.jobInstances;
        synchronized (list) {
            Iterator<JobInstance> it = this.jobInstances.iterator();
            while (it.hasNext()) {
                JobInstance next = it.next();
                if (next.getInstanceId() != jobInstanceIdToRemove) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        List<JobInstance> list = this.jobInstances;
        synchronized (list) {
            for (JobInstance e : this.jobInstances) {
                if (e.getInstanceId() != jobInstanceId) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public List<JobInstance> getJobInstances() {
        return Collections.unmodifiableList(this.jobInstances);
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        List<JobInstance> list = this.jobInstances;
        synchronized (list) {
            for (JobInstance e : this.jobInstances) {
                JobInstanceImpl in = (JobInstanceImpl)e;
                for (JobExecution j : in.getJobExecutions()) {
                    if (j.getExecutionId() != jobExecutionId) continue;
                    return j;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobExecution> getJobExecutions() {
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        List<JobInstance> list = this.jobInstances;
        synchronized (list) {
            for (JobInstance e : this.jobInstances) {
                JobInstanceImpl in = (JobInstanceImpl)e;
                result.addAll(in.getJobExecutions());
            }
        }
        return result;
    }

    @Override
    public StepExecutionImpl createStepExecution(String stepName) {
        StepExecutionImpl stepExecution = new StepExecutionImpl(stepName);
        return stepExecution;
    }

    @Override
    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution(stepExecution);
        this.insertStepExecution(stepExecution, jobExecution);
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, StepExecutionImpl stepExecution) {
        Serializable copy;
        Serializable ser = stepExecution.getPersistentUserData();
        if (ser != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setPersistentUserData(copy);
        }
        if ((ser = stepExecution.getReaderCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setReaderCheckpointInfo(copy);
        }
        if ((ser = stepExecution.getWriterCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setWriterCheckpointInfo(copy);
        }
    }

    protected ApplicationMetaData getApplicationMetaData(ApplicationAndJobName applicationAndJobName, ClassLoader classLoader) {
        ApplicationMetaData result = (ApplicationMetaData)this.applicationMetaDataMap.get(applicationAndJobName);
        if (result == null) {
            try {
                result = new ApplicationMetaData(classLoader);
                ApplicationMetaData old = this.applicationMetaDataMap.putIfAbsent(applicationAndJobName, result);
                if (old != null) {
                    result = old;
                }
            }
            catch (IOException e) {
                throw BatchLogger.LOGGER.failToProcessMetaData(e, applicationAndJobName.toString());
            }
        }
        return result;
    }
}

