/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.Properties;
import org.jberet.config.BatchConfig;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jberet.util.BatchLogger;

public final class JobRepositoryFactory {
    public static final String JOB_REPOSITORY_TYPE_KEY = "job-repository-type";
    public static final String REPOSITORY_TYPE_IN_MEMORY = "in-memory";
    public static final String REPOSITORY_TYPE_JDBC = "jdbc";

    private JobRepositoryFactory() {
    }

    public static JobRepository getJobRepository() {
        Properties configProperties = BatchConfig.getInstance().getConfigProperties();
        String repositoryType = configProperties.getProperty(JOB_REPOSITORY_TYPE_KEY);
        if (repositoryType == null || repositoryType.isEmpty() || repositoryType.equals(REPOSITORY_TYPE_IN_MEMORY)) {
            return InMemoryRepository.getInstance();
        }
        if (repositoryType.equals(REPOSITORY_TYPE_JDBC)) {
            return JdbcRepository.getInstance();
        }
        throw BatchLogger.LOGGER.unrecognizedJobRepositoryType(repositoryType);
    }
}

