/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.jberet.job.Job;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public final class JobExecutionImpl
extends AbstractExecution
implements JobExecution,
Cloneable {
    public static final String JOB_EXECUTION_TIMEOUT_SECONDS_KEY = "org.jberet.job.execution.timeout.seconds";
    public static final long JOB_EXECUTION_TIMEOUT_SECONDS_DEFAULT = 300L;
    private long id;
    private JobInstanceImpl jobInstance;
    private Job substitutedJob;
    private List<StepExecution> stepExecutions = new ArrayList<StepExecution>();
    private List<StepExecutionImpl> inactiveStepExecutions = new ArrayList<StepExecutionImpl>();
    private Properties jobParameters;
    protected long createTime;
    protected long lastUpdatedTime;
    String restartPoint;
    private CountDownLatch jobTerminationlatch = new CountDownLatch(1);
    private CountDownLatch jobStopLatch = new CountDownLatch(1);

    public JobExecutionImpl(JobInstanceImpl jobInstance, Properties jobParameters) throws JobStartException {
        this.jobInstance = jobInstance;
        this.jobParameters = jobParameters;
        this.substitutedJob = BatchUtil.clone(jobInstance.unsubstitutedJob);
        this.startTime = this.createTime = System.currentTimeMillis();
        this.setBatchStatus(BatchStatus.STARTING);
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public JobExecutionImpl clone() {
        JobExecutionImpl result = null;
        try {
            result = (JobExecutionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobName(), "");
        }
        return result;
    }

    public void awaitTerminatioin(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.jobTerminationlatch != null) {
            this.jobTerminationlatch.await(timeout, timeUnit);
        }
    }

    public void awaitStop(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.jobStopLatch != null) {
            this.jobStopLatch.await(timeout, timeUnit);
        }
    }

    public Job getSubstitutedJob() {
        return this.substitutedJob;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public long getExecutionId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobInstance.getJobName();
    }

    public Date getCreateTime() {
        return new Date(this.createTime);
    }

    public Date getLastUpdatedTime() {
        return new Date(this.lastUpdatedTime);
    }

    public JobInstanceImpl getJobInstance() {
        return this.jobInstance;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepExecution> getStepExecutions() {
        List<StepExecution> list = this.stepExecutions;
        synchronized (list) {
            return Collections.unmodifiableList(this.stepExecutions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStepExecution(StepExecution stepExecution) {
        List<StepExecution> list = this.stepExecutions;
        synchronized (list) {
            this.stepExecutions.add(stepExecution);
        }
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public List<StepExecutionImpl> getInactiveStepExecutions() {
        return this.inactiveStepExecutions;
    }

    public void setRestartPoint(String restartPoint) {
        this.restartPoint = restartPoint;
    }

    public String getRestartPoint() {
        return this.restartPoint;
    }

    public boolean isStopRequested() {
        return this.jobStopLatch.getCount() == 0L;
    }

    public void stop() {
        this.jobStopLatch.countDown();
    }

    public void cleanUp() {
        this.jobTerminationlatch.countDown();
        this.jobStopLatch.countDown();
        this.jobStopLatch = null;
        this.jobTerminationlatch = null;
        this.substitutedJob = null;
        this.endTime = System.currentTimeMillis();
    }
}

