/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.JobContext;
import org.jberet.creation.ArtifactFactory;
import org.jberet.job.Job;
import org.jberet.job.Listener;
import org.jberet.job.Listeners;
import org.jberet.job.Step;
import org.jberet.metadata.ApplicationMetaData;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;
import org.jberet.util.PropertyResolver;

public class JobContextImpl
extends AbstractContext
implements JobContext,
Cloneable {
    JobExecutionImpl jobExecution;
    private ApplicationMetaData applicationMetaData;
    private ArtifactFactory artifactFactory;
    JobRepository jobRepository;
    private JobListener[] jobListeners = new JobListener[0];
    private List<Step> executedSteps = Collections.synchronizedList(new ArrayList());
    JobExecutionImpl originalToRestart;

    public JobContextImpl(JobExecutionImpl jobExecution, JobExecutionImpl originalToRestart, ArtifactFactory artifactFactory, JobRepository jobRepository) {
        super(jobExecution.getSubstitutedJob().getId());
        this.jobExecution = jobExecution;
        this.applicationMetaData = jobExecution.getJobInstance().getApplicationMetaData();
        this.classLoader = this.applicationMetaData.getClassLoader();
        this.artifactFactory = artifactFactory;
        this.jobRepository = jobRepository;
        if (originalToRestart != null) {
            this.originalToRestart = originalToRestart;
            this.jobExecution.setRestartPoint(originalToRestart.getRestartPoint());
        }
        PropertyResolver resolver = new PropertyResolver();
        resolver.setJobParameters(jobExecution.getJobParameters());
        resolver.resolve(jobExecution.getSubstitutedJob());
        this.createJobListeners();
    }

    @Override
    public JobContextImpl clone() {
        JobContextImpl result = null;
        try {
            result = (JobContextImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobName(), "");
        }
        result.jobExecution = this.jobExecution.clone();
        return result;
    }

    public boolean isRestart() {
        return this.originalToRestart != null;
    }

    public List<Step> getExecutedSteps() {
        return this.executedSteps;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public JobListener[] getJobListeners() {
        return this.jobListeners;
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.applicationMetaData;
    }

    public Properties getJobParameters() {
        return this.jobExecution.getJobParameters();
    }

    @Override
    public AbstractContext[] getOuterContexts() {
        return new AbstractContext[0];
    }

    public String getJobName() {
        return this.jobExecution.getJobInstance().getJobName();
    }

    public long getInstanceId() {
        return this.jobExecution.getJobInstance().getInstanceId();
    }

    public long getExecutionId() {
        return this.jobExecution.getExecutionId();
    }

    public Properties getProperties() {
        return BatchUtil.toJavaUtilProperties(this.jobExecution.getSubstitutedJob().getProperties());
    }

    @Override
    public org.jberet.job.Properties getProperties2() {
        return this.jobExecution.getSubstitutedJob().getProperties();
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.jobExecution.getBatchStatus();
    }

    @Override
    public String getExitStatus() {
        return this.jobExecution.getExitStatus();
    }

    @Override
    public void setBatchStatus(BatchStatus status) {
        this.jobExecution.setBatchStatus(status);
    }

    @Override
    public void setExitStatus(String status) {
        this.jobExecution.setExitStatus(status);
    }

    @Override
    public JobContextImpl getJobContext() {
        return this;
    }

    public JobExecutionImpl getJobExecution() {
        return this.jobExecution;
    }

    public Job getJob() {
        return this.jobExecution.getSubstitutedJob();
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public <A> A createArtifact(String ref, Class<?> cls, org.jberet.job.Properties props, StepContextImpl ... stepContextForInjection) {
        Map<ArtifactFactory.DataKey, Object> artifactCreationData = this.prepareCreationData(props, stepContextForInjection);
        Object a = null;
        try {
            a = this.artifactFactory.create(ref, cls, this.classLoader, artifactCreationData);
        }
        catch (Exception e) {
            throw BatchLogger.LOGGER.failToCreateArtifact(e, ref);
        }
        return (A)a;
    }

    public Class<?> getArtifactClass(String ref) {
        Map<ArtifactFactory.DataKey, Object> artifactCreationData = this.prepareCreationData(null, new StepContextImpl[0]);
        return this.artifactFactory.getArtifactClass(ref, this.classLoader, artifactCreationData);
    }

    private Map<ArtifactFactory.DataKey, Object> prepareCreationData(org.jberet.job.Properties props, StepContextImpl ... stepContextForInjection) {
        HashMap<ArtifactFactory.DataKey, Object> artifactCreationData = new HashMap<ArtifactFactory.DataKey, Object>();
        artifactCreationData.put(ArtifactFactory.DataKey.APPLICATION_META_DATA, this.applicationMetaData);
        artifactCreationData.put(ArtifactFactory.DataKey.JOB_CONTEXT, this);
        if (props != null) {
            artifactCreationData.put(ArtifactFactory.DataKey.BATCH_PROPERTY, props);
        }
        if (stepContextForInjection.length > 0) {
            artifactCreationData.put(ArtifactFactory.DataKey.STEP_CONTEXT, stepContextForInjection[0]);
        }
        return artifactCreationData;
    }

    public void destroyArtifact(Object ... objs) {
        for (Object obj : objs) {
            this.artifactFactory.destroy(obj);
        }
    }

    public void destroyArtifact(List<?> list) {
        for (Object obj : list) {
            this.artifactFactory.destroy(obj);
        }
    }

    private void createJobListeners() {
        Listeners listeners = this.jobExecution.getSubstitutedJob().getListeners();
        if (listeners != null) {
            List<Listener> listenerList = listeners.getListener();
            int count = listenerList.size();
            this.jobListeners = new JobListener[count];
            for (int i = 0; i < count; ++i) {
                Listener listener = listenerList.get(i);
                this.jobListeners[i] = (JobListener)this.createArtifact(listener.getRef(), null, listener.getProperties(), new StepContextImpl[0]);
            }
        }
    }

    public void saveInactiveStepExecutions() {
        if (this.originalToRestart != null) {
            boolean matched;
            List<StepExecutionImpl> currentInactives = this.jobExecution.getInactiveStepExecutions();
            List<StepExecution> originalStepExecutions = this.originalToRestart.getStepExecutions();
            List<StepExecution> currentStepExecutions = this.jobExecution.getStepExecutions();
            for (StepExecution stepExecution : originalStepExecutions) {
                matched = false;
                for (StepExecution stepExecution2 : currentStepExecutions) {
                    if (!stepExecution.getStepName().equals(stepExecution2.getStepName())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                currentInactives.add((StepExecutionImpl)stepExecution);
            }
            for (StepExecutionImpl stepExecutionImpl : this.originalToRestart.getInactiveStepExecutions()) {
                matched = false;
                for (StepExecutionImpl stepExecutionImpl2 : currentInactives) {
                    if (!stepExecutionImpl.getStepName().equals(stepExecutionImpl2.getStepName())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                currentInactives.add(stepExecutionImpl);
            }
        }
    }
}

