/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.context;

import java.io.Serializable;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.StepContext;
import org.jberet.job.Step;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public class StepContextImpl
extends AbstractContext
implements StepContext,
Cloneable {
    private Step step;
    private StepExecutionImpl stepExecution;
    Boolean allowStartIfComplete;

    public StepContextImpl(Step step, AbstractContext[] outerContexts) {
        super(step.getId(), outerContexts);
        StepExecutionImpl originalStepExecution;
        this.step = step;
        this.classLoader = this.getJobContext().getClassLoader();
        this.stepExecution = this.getJobContext().jobRepository.createStepExecution(this.id);
        JobExecutionImpl originalToRestart = this.getJobContext().originalToRestart;
        if (originalToRestart != null && (originalStepExecution = this.findOriginalStepExecution(originalToRestart)) != null) {
            if (originalStepExecution.getBatchStatus() == BatchStatus.COMPLETED) {
                this.allowStartIfComplete = Boolean.valueOf(step.getAllowStartIfComplete());
                if (this.allowStartIfComplete == Boolean.FALSE) {
                    this.setBatchStatus(BatchStatus.COMPLETED);
                    this.setExitStatus(originalStepExecution.getExitStatus());
                    return;
                }
            }
            if (originalStepExecution.getPersistentUserData() != null) {
                this.stepExecution.setPersistentUserData(originalStepExecution.getPersistentUserData());
            }
            this.stepExecution.setReaderCheckpointInfo(originalStepExecution.getReaderCheckpointInfo());
            this.stepExecution.setWriterCheckpointInfo(originalStepExecution.getWriterCheckpointInfo());
            this.stepExecution.setStartCount(originalStepExecution.getStartCount());
            this.stepExecution.setNumOfPartitions(originalStepExecution.getNumOfPartitions());
            if (originalStepExecution.getPartitionPropertiesIndex() != null) {
                for (Integer i : originalStepExecution.getPartitionPropertiesIndex()) {
                    this.stepExecution.addPartitionPropertiesIndex(i);
                }
            }
            if (originalStepExecution.getPartitionPersistentUserData() != null) {
                for (Serializable d : originalStepExecution.getPartitionPersistentUserData()) {
                    this.stepExecution.addPartitionPersistentUserData(d);
                }
            }
            if (originalStepExecution.getPartitionReaderCheckpointInfo() != null) {
                for (Serializable d : originalStepExecution.getPartitionReaderCheckpointInfo()) {
                    this.stepExecution.addPartitionReaderCheckpointInfo(d);
                }
            }
            if (originalStepExecution.getPartitionWriterCheckpointInfo() != null) {
                for (Serializable d : originalStepExecution.getPartitionWriterCheckpointInfo()) {
                    this.stepExecution.addPartitionWriterCheckpointInfo(d);
                }
            }
        }
        this.stepExecution.setBatchStatus(BatchStatus.STARTING);
    }

    private StepExecutionImpl findOriginalStepExecution(JobExecutionImpl originalToRestart) {
        for (StepExecution stepExecution : originalToRestart.getStepExecutions()) {
            if (!this.id.equals(stepExecution.getStepName())) continue;
            return (StepExecutionImpl)stepExecution;
        }
        for (StepExecutionImpl stepExecutionImpl : originalToRestart.getInactiveStepExecutions()) {
            if (!this.id.equals(stepExecutionImpl.getStepName())) continue;
            return stepExecutionImpl;
        }
        return null;
    }

    @Override
    public StepContextImpl clone() {
        StepContextImpl c = null;
        try {
            c = (StepContextImpl)super.clone();
            c.stepExecution = this.stepExecution.clone();
            c.outerContexts = new AbstractContext[this.outerContexts.length];
            c.outerContexts[0] = this.getJobContext().clone();
            for (int i = 1; i < c.outerContexts.length; ++i) {
                c.outerContexts[i] = this.outerContexts[i];
            }
            c.step = BatchUtil.clone(this.step);
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobContext().getJobName(), this.getStepName());
        }
        return c;
    }

    public Step getStep() {
        return this.step;
    }

    public StepExecutionImpl getStepExecution() {
        return this.stepExecution;
    }

    public Boolean getAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public String getStepName() {
        return this.step.getId();
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.stepExecution.getBatchStatus();
    }

    @Override
    public void setBatchStatus(BatchStatus status) {
        this.stepExecution.setBatchStatus(status);
    }

    @Override
    public String getExitStatus() {
        return this.stepExecution.getExitStatus();
    }

    @Override
    public void setExitStatus(String exitStatus) {
        this.stepExecution.setExitStatus(exitStatus);
    }

    public long getStepExecutionId() {
        return this.stepExecution.getStepExecutionId();
    }

    public Properties getProperties() {
        return BatchUtil.toJavaUtilProperties(this.step.getProperties());
    }

    @Override
    public org.jberet.job.Properties getProperties2() {
        return this.step.getProperties();
    }

    public Serializable getPersistentUserData() {
        return this.stepExecution.getPersistentUserData();
    }

    public void setPersistentUserData(Serializable data) {
        this.stepExecution.setPersistentUserData(data);
    }

    public Exception getException() {
        return this.stepExecution.getException();
    }

    public void setException(Exception e) {
        this.stepExecution.setException(e);
    }

    public Metric[] getMetrics() {
        return this.stepExecution.getMetrics();
    }

    public void savePersistentData() {
        this.getJobContext().jobRepository.savePersistentData(this.getJobContext().jobExecution, this.stepExecution);
    }
}

