/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.metric;

import java.io.Serializable;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.StepContext;

public class MetricImpl
implements Metric,
Serializable {
    private static final long serialVersionUID = 1L;
    private Metric.MetricType type;
    private long value;

    public MetricImpl(Metric.MetricType type) {
        this.type = type;
    }

    public MetricImpl(Metric.MetricType type, long value1) {
        this.type = type;
        this.value = value1;
    }

    public Metric.MetricType getType() {
        return this.type;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value1) {
        this.value = value1;
    }

    public void increment(long i) {
        this.value += i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricImpl)) {
            return false;
        }
        MetricImpl metric = (MetricImpl)o;
        return this.type == metric.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricImpl");
        sb.append("{name='").append(this.type).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public static long getMetric(StepExecution stepExecution, Metric.MetricType type) {
        for (Metric m : stepExecution.getMetrics()) {
            if (m.getType() != type) continue;
            return m.getValue();
        }
        return 0L;
    }

    public static long getMetric(StepContext stepContext, Metric.MetricType type) {
        for (Metric m : stepContext.getMetrics()) {
            if (m.getType() != type) continue;
            return m.getValue();
        }
        return 0L;
    }
}

