/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import java.util.regex.Pattern;
import javax.batch.runtime.BatchStatus;
import org.jberet.job.End;
import org.jberet.job.Fail;
import org.jberet.job.Next;
import org.jberet.job.Stop;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;

public abstract class AbstractRunner<C extends AbstractContext>
implements Runnable {
    protected String id;
    protected C batchContext;
    protected JobContextImpl jobContext;
    protected CompositeExecutionRunner enclosingRunner;

    protected AbstractRunner(C batchContext, CompositeExecutionRunner enclosingRunner) {
        this.id = ((AbstractContext)batchContext).getId();
        this.batchContext = batchContext;
        this.jobContext = ((AbstractContext)batchContext).getJobContext();
        this.enclosingRunner = enclosingRunner;
    }

    protected static final boolean matches(String text, String pattern) {
        boolean containsAsterisk;
        if (pattern.equals("*")) {
            return true;
        }
        boolean containsQuestionMark = pattern.contains("?");
        if (containsQuestionMark) {
            pattern = pattern.replace('?', '.');
        }
        if (containsAsterisk = pattern.contains("*")) {
            pattern = pattern.replace("*", ".*");
        }
        if (!containsAsterisk && !containsQuestionMark) {
            return text.equals(pattern);
        }
        return Pattern.matches(pattern, text);
    }

    protected String resolveTransitionElements(List<?> transitionElements, String nextAttr, boolean partOfDecision) {
        String exitStatus = ((AbstractContext)this.batchContext).getExitStatus();
        for (Object e : transitionElements) {
            if (e instanceof Next) {
                Next next = (Next)e;
                if (!AbstractRunner.matches(exitStatus, next.getOn())) continue;
                return next.getTo();
            }
            if (e instanceof End) {
                End end = (End)e;
                if (!AbstractRunner.matches(exitStatus, end.getOn())) continue;
                this.setOuterContextStatus(((AbstractContext)this.batchContext).getOuterContexts(), BatchStatus.COMPLETED, exitStatus, end.getExitStatus(), partOfDecision);
                return null;
            }
            if (e instanceof Fail) {
                Fail fail = (Fail)e;
                if (!AbstractRunner.matches(exitStatus, fail.getOn())) continue;
                this.setOuterContextStatus(((AbstractContext)this.batchContext).getOuterContexts(), BatchStatus.FAILED, exitStatus, fail.getExitStatus(), partOfDecision);
                return null;
            }
            Stop stop = (Stop)e;
            if (!AbstractRunner.matches(exitStatus, stop.getOn())) continue;
            this.setOuterContextStatus(((AbstractContext)this.batchContext).getOuterContexts(), BatchStatus.STOPPED, exitStatus, stop.getExitStatus(), partOfDecision);
            String restartPoint = stop.getRestart();
            if (restartPoint != null) {
                ((AbstractContext)this.batchContext).getJobContext().getJobExecution().setRestartPoint(restartPoint);
            }
            return null;
        }
        return nextAttr;
    }

    private void setOuterContextStatus(AbstractContext[] outerContexts, BatchStatus batchStatus, String currentExitStatus, String newExitStatus, boolean partOfDecision) {
        String exitStatusToUse = partOfDecision ? (newExitStatus != null ? newExitStatus : currentExitStatus) : newExitStatus;
        if (partOfDecision) {
            ((AbstractContext)this.batchContext).setBatchStatus(batchStatus);
            ((AbstractContext)this.batchContext).setExitStatus(exitStatusToUse);
        }
        for (AbstractContext c : outerContexts) {
            c.setBatchStatus(batchStatus);
            if (partOfDecision) {
                c.setExitStatus(exitStatusToUse);
                continue;
            }
            if (exitStatusToUse == null) continue;
            c.setExitStatus(exitStatusToUse);
        }
    }
}

